/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.despawningspawners;

import com.buuz135.despawningspawners.DespawningConfig;
import com.buuz135.despawningspawners.SpawnerSavedData;
import com.buuz135.despawningspawners.SpawnerStorage;
import java.awt.Color;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="despawningspawners", name="Despawning Spawners", version="1.1", dependencies="required:forge@[14.23.1.2596,);", acceptedMinecraftVersions="[1.12.2]")
public class DespawningSpawners {
    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SpawnerStorage.register();
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityMobSpawner) {
            event.addCapability(new ResourceLocation("despawningspawners", "spawner_storage"), (ICapabilityProvider)new SpawnerStorage(DespawningConfig.maxSpawnerSpawns));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        TileEntity spawner;
        BlockPos pos = this.getSpawner(event);
        if (pos != null && (spawner = event.getWorld().func_175625_s(pos)) instanceof TileEntityMobSpawner && spawner.hasCapability(SpawnerStorage.SPAWNER_CAPABILITY, null)) {
            SpawnerStorage storage = (SpawnerStorage)spawner.getCapability(SpawnerStorage.SPAWNER_CAPABILITY, null);
            SpawnerSavedData data = (SpawnerSavedData)event.getWorld().getPerWorldStorage().func_75742_a(SpawnerSavedData.class, "SPAWNERS_DATA");
            if (data != null && data.getSpawners().containsKey(pos)) {
                storage.setAmount(data.getSpawners().get(pos));
                data.getSpawners().remove(pos);
            }
            storage.setAmount(storage.getAmount() - 1);
            spawner.func_70296_d();
            if (DespawningConfig.displaySpawnerParticle && event.getWorld() instanceof WorldServer) {
                WorldServer worldServer = (WorldServer)event.getWorld();
                Color color = Color.GREEN;
                if ((double)DespawningConfig.maxSpawnerSpawns * 0.5 >= (double)storage.getAmount()) {
                    color = Color.YELLOW;
                }
                if ((double)DespawningConfig.maxSpawnerSpawns * 0.1 >= (double)storage.getAmount()) {
                    color = Color.RED;
                }
                Random random = worldServer.field_73012_v;
                for (int i = 0; i < DespawningConfig.amountOfParticles; ++i) {
                    worldServer.func_180505_a(EnumParticleTypes.REDSTONE, true, (double)pos.func_177958_n() + 1.5 - random.nextDouble() * 2.0, (double)pos.func_177956_o() + 1.5 - random.nextDouble() * 2.0, (double)pos.func_177952_p() + 1.5 - random.nextDouble() * 2.0, 0, (double)color.getRed() / 255.0 - 1.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, 1.0, new int[0]);
                }
            }
            if (storage.getAmount() <= 0) {
                event.getWorld().func_175655_b(pos, true);
            }
        }
    }

    public BlockPos getSpawner(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getSpawner() != null) {
            return event.getSpawner().func_177221_b();
        }
        return null;
    }
}

