/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.progressiontweaks.blocks;

import com.theprogrammingturkey.gobblecore.IModCore;
import com.theprogrammingturkey.gobblecore.blocks.BaseBlock;
import com.theprogrammingturkey.gobblecore.network.NetworkManager;
import com.theprogrammingturkey.progressiontweaks.ProgressionCore;
import com.theprogrammingturkey.progressiontweaks.blocks.ProgressionBlocks;
import com.theprogrammingturkey.progressiontweaks.blocks.tileentities.TileFirePit;
import com.theprogrammingturkey.progressiontweaks.network.PacketUdateFirePit;
import com.theprogrammingturkey.progressiontweaks.registries.FirePitRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFirePit
extends BaseBlock
implements ITileEntityProvider {
    private boolean lit;

    public BlockFirePit(boolean lit) {
        super("fire_pit_" + (lit ? "lit" : "unlit"));
        this.lit = lit;
        this.func_149711_c(2.0f);
        this.func_149713_g(0);
        if (lit) {
            this.func_149715_a(0.9375f);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileFirePit();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float side, float hitX, float hitY) {
        if (!(world.func_175625_s(pos) instanceof TileFirePit)) {
            return false;
        }
        TileFirePit te = (TileFirePit)world.func_175625_s(pos);
        if (world.field_72995_K || player == null || player instanceof FakePlayer) {
            return true;
        }
        if (te != null) {
            ItemStack heldItem = player.func_184586_b(hand);
            boolean flag = false;
            FirePitRegistry.CookingResult result = FirePitRegistry.INSTANCE.getResultFromInput(heldItem);
            if (result != null && te.getItemCooking() == null) {
                ItemStack output = result.getResult();
                int burntime = result.getDuration();
                if (output != null && te.getItemCooking() == null) {
                    te.startCooking(heldItem, burntime);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    flag = true;
                }
            } else {
                int burntime = FirePitRegistry.INSTANCE.getBurnTimeFromFuel(heldItem);
                if (burntime != -1) {
                    te.addBurnTime(burntime);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    flag = true;
                } else {
                    te.dropCurrentItem(player);
                    flag = true;
                }
            }
            if (flag) {
                NetworkManager.getSimpleNetwork((IModCore)ProgressionCore.instance).sendToAll((IMessage)new PacketUdateFirePit(te.getItemCooking(), te.getBurnTimeLeft(), te.getCookTimeLeft(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
                return true;
            }
        }
        return false;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (this.lit) {
            entityIn.func_70015_d(5);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.lit) {
            if (rand.nextInt(24) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            double x = 0.5 + (double)pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            worldIn.func_175688_a(EnumParticleTypes.FLAME, x, y, z, rand.nextDouble() / 10.0 - 0.05, (double)0.05f, rand.nextDouble() / 10.0 - 0.05, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y + 0.75, z, rand.nextDouble() / 10.0 - 0.05, (double)0.01f, rand.nextDouble() / 10.0 - 0.05, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ProgressionBlocks.FIRE_PIT_UNLIT);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ProgressionBlocks.FIRE_PIT_UNLIT);
    }
}

