/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.progressiontweaks.config;

import com.theprogrammingturkey.gobblecore.config.QueuedMessageReporter;
import com.theprogrammingturkey.gobblecore.util.GameUtil;
import com.theprogrammingturkey.progressiontweaks.config.ProgressionSettings;
import com.theprogrammingturkey.progressiontweaks.registries.FirePitRegistry;
import java.io.File;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;

public class ProgressionConfigLoader {
    public static Configuration config;
    public static final String firePitCat = "Firepit Settings";
    public static final String itemCat = "Item Settings";

    public static void loadConfigSettings(File file) {
        config = new Configuration(file);
    }

    public static void loadFromConfig() {
        String[] fuels;
        int duration;
        String[] recipes;
        config.load();
        config.setCategoryComment(firePitCat, "Fire Pit Settings");
        FirePitRegistry.INSTANCE.clearRegistry();
        for (String s : recipes = config.getStringList("Recipes", firePitCat, new String[0], "Recipes for the fire pit to be able to cook. Format, things in () are optional -> \"ModID:ItemName(:meta)-ModID:ItemName(:meta)-duration-xp\" With the first item being the input and the second being the cooked output.")) {
            String[] items = s.split("-");
            if (items.length == 4) {
                ItemStack stack1 = ProgressionConfigLoader.parseItemStack(items[0], s);
                ItemStack stack2 = ProgressionConfigLoader.parseItemStack(items[1], s);
                duration = ProgressionConfigLoader.parseInt(items[2], s);
                int xp = ProgressionConfigLoader.parseInt(items[3], s);
                if (stack1 == null || stack2 == null) continue;
                FirePitRegistry.INSTANCE.registerCookingRecipe(stack1, stack2, duration, xp);
                continue;
            }
            ProgressionConfigLoader.error("Failed to parse fire pit recipe with the input of \"" + s + "\"");
        }
        for (String s : fuels = config.getStringList("Fuels", firePitCat, new String[0], "Fuel items for the fire pit to be able to accept. Format, things in () are optional -> \"ModID:ItemName(:meta)-duration\" With duration in ticks.")) {
            String[] items = s.split("-");
            if (items.length == 2) {
                ItemStack stack = ProgressionConfigLoader.parseItemStack(items[0], s);
                duration = ProgressionConfigLoader.parseInt(items[1], s);
                if (stack == null) continue;
                FirePitRegistry.INSTANCE.registerFuel(stack, duration);
                continue;
            }
            ProgressionConfigLoader.error("Failed to parse fire pit fuel with the input of \"" + s + "\"");
        }
        ProgressionSettings.firePitAttractionRadius = config.getInt("Attraction Radius", firePitCat, 16, 1, 100, "Attraction radius for the fire pit to make the mobs attact to. Square radius from corner to center.");
        ProgressionSettings.SpearBreakChance = config.getInt("Spear Break Chance", itemCat, 15, 0, Integer.MAX_VALUE, "Chance of a thrown spear to break. 1 in x chance. Set to 0 for never.");
        config.save();
    }

    private static ItemStack parseItemStack(String stackString, String recipe) {
        ItemStack toReturn = null;
        String[] item = stackString.split(":");
        if (item.length >= 2) {
            int meta = 0;
            if (item.length == 3) {
                meta = ProgressionConfigLoader.parseInt(item[2], recipe);
            }
            toReturn = GameUtil.getItemStack((String)item[0], (String)item[1], (int)1, (int)meta);
        }
        if (toReturn == null) {
            ProgressionConfigLoader.error("Failed to parse itemstack of \"" + stackString + "\" for the recipe \"" + recipe + "\".");
        }
        return toReturn;
    }

    private static int parseInt(String intString, String recipe) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            ProgressionConfigLoader.error("Failed to parse integer of \"" + intString + "\" for the recipe \"" + recipe + "\". Defaulting to 1.");
            return 1;
        }
    }

    private static void error(String message) {
        QueuedMessageReporter.queueErrorMessage((TextFormatting)TextFormatting.RED, (String)"Progression Tweaks", (String)message);
    }
}

