/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;
import buildcraft.silicon.EnumAssemblyRecipeState;
import buildcraft.silicon.container.ContainerAssemblyTable;
import buildcraft.silicon.gui.LedgerTablePower;
import buildcraft.silicon.tile.TileAssemblyTable;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiAssemblyTable
extends GuiBC8<ContainerAssemblyTable> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftsilicon:textures/gui/assembly_table.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 220;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0.0, 0.0, 176.0, 220.0);
    private static final GuiIcon ICON_SAVED = new GuiIcon(TEXTURE_BASE, 176.0, 0.0, 16.0, 16.0);
    private static final GuiIcon ICON_SAVED_ENOUGH = new GuiIcon(TEXTURE_BASE, 176.0, 16.0, 16.0, 16.0);
    private static final GuiIcon ICON_SAVED_ENOUGH_ACTIVE = new GuiIcon(TEXTURE_BASE, 176.0, 32.0, 16.0, 16.0);
    private static final GuiIcon ICON_PROGRESS = new GuiIcon(TEXTURE_BASE, 176.0, 48.0, 4.0, 70.0);
    private static final GuiRectangle RECT_PROGRESS = new GuiRectangle(86.0, 36.0, 4.0, 70.0);

    public GuiAssemblyTable(ContainerAssemblyTable container) {
        super((ContainerBC_Neptune)container);
        this.field_146999_f = 176;
        this.field_147000_g = 220;
        this.mainGui.shownElements.add(new LedgerTablePower(this.mainGui, (TileAssemblyTable)container.tile, true));
    }

    private IGuiPosition getPos(int index) {
        int posX = index % 3;
        int posY = index / 3;
        return new PositionAbsolute((double)(116 + posX * 18), (double)(36 + posY * 18));
    }

    private IGuiArea getArea(int index) {
        return index < 12 ? new GuiRectangle(16.0, 16.0).offset((IGuiPosition)this.mainGui.rootElement).offset(this.getPos(index)) : GuiRectangle.ZERO;
    }

    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt((IGuiPosition)this.mainGui.rootElement);
        long target = ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).getTarget();
        if (target != 0L) {
            double v = (double)((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).power / (double)target;
            ICON_PROGRESS.drawCutInside(new GuiRectangle(GuiAssemblyTable.RECT_PROGRESS.x, (double)((int)(GuiAssemblyTable.RECT_PROGRESS.y + GuiAssemblyTable.RECT_PROGRESS.height * Math.max(1.0 - v, 0.0))), GuiAssemblyTable.RECT_PROGRESS.width, (double)((int)Math.ceil(GuiAssemblyTable.RECT_PROGRESS.height * Math.min(v, 1.0)))).offset((IGuiPosition)this.mainGui.rootElement));
        }
        for (int i = 0; i < ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.size(); ++i) {
            EnumAssemblyRecipeState state = new ArrayList<EnumAssemblyRecipeState>(((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.values()).get(i);
            if (state == EnumAssemblyRecipeState.SAVED) {
                ICON_SAVED.drawAt((IGuiPosition)this.getArea(i));
            }
            if (state == EnumAssemblyRecipeState.SAVED_ENOUGH) {
                ICON_SAVED_ENOUGH.drawAt((IGuiPosition)this.getArea(i));
            }
            if (state != EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE) continue;
            ICON_SAVED_ENOUGH_ACTIVE.drawAt((IGuiPosition)this.getArea(i));
        }
    }

    protected void drawForegroundLayer() {
        String title = I18n.func_135052_a((String)"tile.assemblyTableBlock.name", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.field_147003_i + (this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2, this.field_147009_r + 15, 0x404040);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (int i = 0; i < ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.size(); ++i) {
                TileAssemblyTable.AssemblyInstruction instruction = new ArrayList<TileAssemblyTable.AssemblyInstruction>(((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.keySet()).get(i);
                EnumAssemblyRecipeState state = new ArrayList<EnumAssemblyRecipeState>(((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).recipesStates.values()).get(i);
                if (!this.getArea(i).contains((double)mouseX, (double)mouseY)) continue;
                ((TileAssemblyTable)((ContainerAssemblyTable)this.container).tile).sendRecipeStateToServer(instruction, state == EnumAssemblyRecipeState.POSSIBLE ? EnumAssemblyRecipeState.SAVED : EnumAssemblyRecipeState.POSSIBLE);
            }
        }
    }
}

