/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.item;

import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.lib.client.render.font.SpecialColourFontRenderer;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.silicon.BCSiliconPlugs;
import buildcraft.silicon.plug.PluggableLens;
import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPluggableLens
extends ItemBC_Neptune
implements IItemPluggable {
    public ItemPluggableLens(String id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public static LensData getData(ItemStack stack) {
        return new LensData(stack);
    }

    @Nonnull
    public ItemStack getStack(EnumDyeColor colour, boolean isFilter) {
        return this.getStack(new LensData(colour, isFilter));
    }

    @Nonnull
    public ItemStack getStack(LensData variant) {
        ItemStack stack = new ItemStack((Item)this);
        variant.writeToStack(stack);
        return stack;
    }

    public PipePluggable onPlace(@Nonnull ItemStack stack, IPipeHolder holder, EnumFacing side, EntityPlayer player, EnumHand hand) {
        IPipe pipe = holder.getPipe();
        if (pipe == null || !(pipe.getFlow() instanceof IFlowItems)) {
            return null;
        }
        LensData data = ItemPluggableLens.getData(stack);
        SoundUtil.playBlockPlace((World)holder.getPipeWorld(), (BlockPos)holder.getPipePos(), (IBlockState)Blocks.field_150348_b.func_176223_P());
        PluggableDefinition def = BCSiliconPlugs.lens;
        return new PluggableLens(def, holder, side, data.colour, data.isFilter);
    }

    public String func_77653_i(ItemStack stack) {
        LensData data = ItemPluggableLens.getData(stack);
        String colour = data.colour == null ? LocaleUtil.localize((String)"color.clear") : ColourUtil.getTextFullTooltipSpecial((EnumDyeColor)data.colour);
        String first = LocaleUtil.localize((String)(data.isFilter ? "item.Filter.name" : "item.Lens.name"));
        return colour + " " + first;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return SpecialColourFontRenderer.INSTANCE;
    }

    protected void addSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < 34; ++i) {
            subItems.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        for (int i = 0; i < 34; ++i) {
            variants.put(i, (Object)new ModelResourceLocation("buildcraftsilicon:lens_item#inventory"));
        }
    }

    public static class LensData {
        public final EnumDyeColor colour;
        public final boolean isFilter;

        public LensData(EnumDyeColor colour, boolean isFilter) {
            this.colour = colour;
            this.isFilter = isFilter;
        }

        public LensData(ItemStack stack) {
            this(stack.func_77952_i());
        }

        public LensData(int damage) {
            if (damage >= 32) {
                this.colour = null;
                this.isFilter = damage == 33;
            } else {
                this.colour = EnumDyeColor.func_176766_a((int)(damage & 0xF));
                this.isFilter = damage >= 16;
            }
        }

        public int getItemDamage() {
            if (this.colour == null) {
                return this.isFilter ? 33 : 32;
            }
            return this.colour.func_176767_b() + (this.isFilter ? 16 : 0);
        }

        public ItemStack writeToStack(ItemStack stack) {
            stack.func_77964_b(this.getItemDamage());
            return stack;
        }
    }
}

