/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.plug;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.facades.FacadeAPI;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.api.facades.IFacadeRegistry;
import buildcraft.api.facades.IFacadeState;
import buildcraft.lib.BCLib;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadePhasedState;
import buildcraft.silicon.recipe.FacadeSwapRecipe;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum FacadeStateManager implements IFacadeRegistry
{
    INSTANCE;

    public static final boolean DEBUG;
    public static final SortedMap<IBlockState, FacadeBlockStateInfo> validFacadeStates;
    public static final Map<ItemStackKey, List<FacadeBlockStateInfo>> stackFacades;
    public static FacadeBlockStateInfo defaultState;
    public static FacadeBlockStateInfo previewState;
    private static final Map<Block, String> disabledBlocks;
    private static final Map<IBlockState, ItemStack> customBlocks;
    private static final List<String> KNOWN_INVALID_REPORTED_MODS;

    public static FacadeBlockStateInfo getInfoForBlock(Block block) {
        return FacadeStateManager.getInfoForState(block.func_176223_P());
    }

    private static FacadeBlockStateInfo getInfoForState(IBlockState state) {
        return (FacadeBlockStateInfo)validFacadeStates.get(state);
    }

    public static void receiveInterModComms(FMLInterModComms.IMCMessage message) {
        String id = message.key;
        if ("facade_disable_block".equals(id)) {
            if (!message.isResourceLocationMessage()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a resourcelocation value, not a " + message);
                return;
            }
            ResourceLocation loc = message.getResourceLocationValue();
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)loc);
            if (block == Blocks.field_150350_a) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a valid block target, not " + block + " (" + message + ")");
                return;
            }
            disabledBlocks.put(block, message.getSender());
        } else if ("facade_custom_map_block_item".equals(id)) {
            if (!message.isNBTMessage()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have an nbt value, not a " + message);
                return;
            }
            NBTTagCompound nbt = message.getNBTValue();
            String regName = nbt.func_74779_i("block_registry_name");
            int meta = nbt.func_74762_e("block_meta");
            ItemStack stack = new ItemStack(nbt.func_74775_l("item_stack"));
            if (regName.isEmpty()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a registry name for the block, stored as " + "block_registry_name");
                return;
            }
            if (stack.func_190926_b()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a valid ItemStack stored in " + "item_stack");
                return;
            }
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(regName));
            if (block == Blocks.field_150350_a) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a valid block target, not " + block + " (" + message + ")");
                return;
            }
            IBlockState state = block.func_176203_a(meta);
            customBlocks.put(state, stack);
        }
    }

    private static ActionResult<String> isValidFacadeBlock(Block block) {
        String disablingMod = disabledBlocks.get(block);
        if (disablingMod != null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)("it has been disabled by " + disablingMod));
        }
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            return new ActionResult(EnumActionResult.FAIL, (Object)"it is a fluid block");
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)"");
        }
        return new ActionResult(EnumActionResult.PASS, (Object)"");
    }

    private static ActionResult<String> isValidFacadeState(IBlockState state) {
        if (state.func_177230_c().hasTileEntity(state)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)"it has a tile entity");
        }
        if (state.func_185901_i() != EnumBlockRenderType.MODEL) {
            return new ActionResult(EnumActionResult.FAIL, (Object)"it doesn't have a normal model");
        }
        if (!state.func_185917_h()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)"it isn't a full cube");
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)"");
    }

    @Nonnull
    private static ItemStack getRequiredStack(IBlockState state) {
        ItemStack stack = customBlocks.get(state);
        if (stack != null) {
            return stack;
        }
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            item = block.func_180660_a(state, new Random(0L), 0);
        }
        return new ItemStack(item, 1, block.func_180651_a(state));
    }

    public static void init() {
        defaultState = new FacadeBlockStateInfo(Blocks.field_150350_a.func_176223_P(), StackUtil.EMPTY, ImmutableSet.of());
        if (FacadeAPI.facadeItem == null) {
            previewState = defaultState;
            return;
        }
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!DEBUG && KNOWN_INVALID_REPORTED_MODS.contains(block.getRegistryName().func_110624_b()) && "7.99.24.1".startsWith("7.99")) {
                BCLog.logger.warn("[silicon.facade] Skipping " + block + " as it has been added to the list of broken mods!");
                continue;
            }
            boolean allPropertiesOk = true;
            for (IProperty property : block.func_176194_O().func_177623_d()) {
                allPropertiesOk &= FacadeStateManager.doesPropertyConform(property);
            }
            if (!allPropertiesOk) continue;
            ActionResult<String> result = FacadeStateManager.isValidFacadeBlock(block);
            if (result.func_188397_a() != EnumActionResult.PASS && result.func_188397_a() != EnumActionResult.SUCCESS) {
                if (!DEBUG) continue;
                BCLog.logger.info("[silicon.facade] Disallowed block " + block.getRegistryName() + " because " + (String)result.func_188398_b());
                continue;
            }
            if (DEBUG && result.func_188397_a() == EnumActionResult.SUCCESS) {
                BCLog.logger.info("[silicon.facade] Allowed block " + block.getRegistryName());
            }
            HashMap<IBlockState, ItemStack> usedStates = new HashMap<IBlockState, ItemStack>();
            HashMap<ItemStackKey, Map> varyingProperties = new HashMap<ItemStackKey, Map>();
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                if (result.func_188397_a() != EnumActionResult.SUCCESS) {
                    result = FacadeStateManager.isValidFacadeState(state);
                    if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                        if (DEBUG) {
                            BCLog.logger.info("[silicon.facade] Allowed state " + state);
                        }
                    } else {
                        if (!DEBUG) continue;
                        BCLog.logger.info("[silicon.facade] Disallowed state " + state + " because " + (String)result.func_188398_b());
                        continue;
                    }
                }
                ItemStack stack = FacadeStateManager.getRequiredStack(state);
                usedStates.put(state, stack);
                ItemStackKey stackKey = new ItemStackKey(stack);
                HashMap vars2 = (HashMap)varyingProperties.get(stackKey);
                if (vars2 == null) {
                    vars2 = new HashMap(state.func_177228_b());
                    varyingProperties.put(stackKey, vars2);
                    continue;
                }
                for (Map.Entry entry : state.func_177228_b().entrySet()) {
                    IProperty prop = (IProperty)entry.getKey();
                    Comparable value = (Comparable)entry.getValue();
                    if (vars2.get(prop) == value) continue;
                    vars2.put(prop, null);
                }
            }
            PacketBufferBC testingBuffer = PacketBufferBC.asPacketBufferBc((ByteBuf)Unpooled.buffer());
            varyingProperties.forEach((key, vars) -> {
                if (DEBUG) {
                    BCLog.logger.info("[silicon.facade]   pre-" + key + ":");
                    vars.keySet().forEach(p -> BCLog.logger.info("[silicon.facade]       " + p));
                }
                vars.values().removeIf(Objects::nonNull);
                if (DEBUG && !vars.isEmpty()) {
                    BCLog.logger.info("[silicon.facade]   " + key + ":");
                    vars.keySet().forEach(p -> BCLog.logger.info("[silicon.facade]       " + p));
                }
            });
            for (Map.Entry entry : usedStates.entrySet()) {
                IBlockState state = (IBlockState)entry.getKey();
                ItemStack stack = (ItemStack)entry.getValue();
                Map vars3 = (Map)varyingProperties.get(new ItemStackKey(stack));
                try {
                    ImmutableSet varSet = ImmutableSet.copyOf(vars3.keySet());
                    FacadeBlockStateInfo info = new FacadeBlockStateInfo(state, stack, varSet);
                    validFacadeStates.put(state, info);
                    if (!info.requiredStack.func_190926_b()) {
                        ItemStackKey stackKey = new ItemStackKey(info.requiredStack);
                        stackFacades.computeIfAbsent(stackKey, k -> new ArrayList()).add(info);
                    }
                    FacadePhasedState phasedState = info.createPhased(null);
                    NBTTagCompound nbt = phasedState.writeToNbt();
                    FacadePhasedState read = FacadePhasedState.readFromNbt(nbt);
                    if (read.stateInfo != info) {
                        throw new IllegalStateException("Read (from NBT) state was different! (\n\t" + read.stateInfo + "\n !=\n\t" + info + "\n\tNBT = " + nbt + "\n)");
                    }
                    phasedState.writeToBuffer(testingBuffer);
                    read = FacadePhasedState.readFromBuffer(testingBuffer);
                    if (read.stateInfo != info) {
                        throw new IllegalStateException("Read (from buffer) state was different! (\n\t" + read.stateInfo + "\n !=\n\t" + info + "\n)");
                    }
                    testingBuffer.clear();
                    if (!DEBUG) continue;
                    BCLog.logger.info("[silicon.facade]   Added " + info);
                }
                catch (Throwable t) {
                    String msg = "Scanning facade states";
                    msg = msg + "\n\tState = " + state;
                    msg = msg + "\n\tBlock = " + FacadeStateManager.safeToString(() -> state.func_177230_c().getRegistryName());
                    msg = msg + "\n\tStack = " + stack;
                    msg = msg + "\n\tvarying-properties: {";
                    for (Map.Entry varEntry : vars3.entrySet()) {
                        msg = msg + "\n\t\t" + varEntry.getKey() + " = " + varEntry.getValue();
                    }
                    msg = msg + "\n\t}";
                    throw new IllegalStateException(msg.replace("\t", "    "), t);
                }
            }
        }
        previewState = (FacadeBlockStateInfo)validFacadeStates.get(Blocks.field_150336_V.func_176223_P());
        FacadeSwapRecipe.genRecipes();
    }

    private static <V extends Comparable<V>> boolean doesPropertyConform(IProperty<V> property) {
        try {
            property.func_185929_b("");
        }
        catch (AbstractMethodError error) {
            String message = "Invalid IProperty object detected!";
            message = message + "\n  Class = " + property.getClass();
            message = message + "\n  Method not overriden: IProperty.parseValue(String)";
            RuntimeException exception = new RuntimeException(message, error);
            if (BCLib.DEV || !"1.12.2".equals("1.12.2")) {
                throw exception;
            }
            BCLog.logger.error("[silicon.facade] Invalid property!", (Throwable)exception);
            return false;
        }
        boolean allFine = true;
        Iterator iterator = property.func_177700_c().iterator();
        while (iterator.hasNext()) {
            Comparable value;
            String name = property.func_177702_a(value = (Comparable)iterator.next());
            Optional optional = property.func_185929_b(name);
            Comparable parsed = optional == null ? null : (Comparable)optional.orNull();
            if (Objects.equals(value, parsed)) continue;
            allFine = false;
            String message = "Invalid property value detected!";
            message = message + "\n  Property class = " + property.getClass();
            message = message + "\n  Property = " + property;
            message = message + "\n  Possible Values = " + property.func_177700_c();
            message = message + "\n  Value Name = " + name;
            message = message + "\n  Value (original) = " + value;
            message = message + "\n  Value (parsed) = " + parsed;
            message = message + "\n  Value class (original) = " + (value == null ? null : value.getClass());
            message = message + "\n  Value class (parsed) = " + (parsed == null ? null : parsed.getClass());
            if (optional == null) {
                message = message + "\n  IProperty.parseValue() -> Null com.google.common.base.Optional!!";
            }
            message = message + "\n";
            RuntimeException exception = new RuntimeException(message);
            if (BCLib.DEV || !"1.12.2".equals("1.12.2")) {
                throw exception;
            }
            BCLog.logger.error("[silicon.facade] Invalid property!", (Throwable)exception);
        }
        return allFine;
    }

    private static String safeToString(Callable<Object> callable) {
        try {
            return Objects.toString(callable.call());
        }
        catch (Throwable t) {
            return "~~ERROR~~" + t.getMessage();
        }
    }

    public Collection<? extends IFacadeState> getValidFacades() {
        return validFacadeStates.values();
    }

    public IFacadePhasedState createPhasedState(IFacadeState state, EnumDyeColor activeColor) {
        return new FacadePhasedState((FacadeBlockStateInfo)state, activeColor);
    }

    public IFacade createPhasedFacade(IFacadePhasedState[] states, boolean isHollow) {
        FacadePhasedState[] realStates = new FacadePhasedState[states.length];
        for (int i = 0; i < states.length; ++i) {
            realStates[i] = (FacadePhasedState)states[i];
        }
        return new FacadeInstance(realStates, isHollow);
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog((String)"silicon.facade");
        disabledBlocks = new HashMap<Block, String>();
        customBlocks = new HashMap<IBlockState, ItemStack>();
        KNOWN_INVALID_REPORTED_MODS = Arrays.asList(new String[0]);
        validFacadeStates = new TreeMap<IBlockState, FacadeBlockStateInfo>(BlockUtil.blockStateComparator());
        stackFacades = new HashMap<ItemStackKey, List<FacadeBlockStateInfo>>();
    }
}

