/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.poweradapters.adapters;

import com.jarhax.poweradapters.InternalBattery;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class IPowerAdapter {
    private final InternalBattery battery;

    public IPowerAdapter(InternalBattery battery) {
        this.battery = battery;
    }

    abstract long getExchangeRate();

    public long getLocalCapacity() {
        return this.battery.getCapacity() / this.getExchangeRate();
    }

    public long getLocalStored() {
        return this.battery.getStored() / this.getExchangeRate();
    }

    public long getLocalInput() {
        return this.battery.getInput() / this.getExchangeRate();
    }

    public long getLocalOutput() {
        return this.battery.getOutput() / this.getExchangeRate();
    }

    public long takePower(long requested, boolean simulated) {
        long removedPower = Math.min(this.getLocalStored(), Math.min(this.getLocalOutput(), requested));
        if (!simulated) {
            this.battery.takePower(removedPower * this.getExchangeRate());
        }
        return removedPower;
    }

    public long addPower(long power, boolean simulated) {
        long acceptedPower = Math.min(this.getLocalInput(), power);
        if (this.battery.getStored() == this.battery.getCapacity()) {
            acceptedPower = 0L;
        }
        if (!simulated) {
            this.battery.addPower(acceptedPower * this.getExchangeRate());
        }
        return acceptedPower;
    }

    public InternalBattery getInternalBattery() {
        return this.battery;
    }

    public abstract void distributePower(World var1, BlockPos var2);

    public abstract boolean hasCapability(Capability<?> var1, EnumFacing var2);

    public abstract <T> T getCapability(Capability<T> var1, EnumFacing var2);
}

