/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.integration;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.TreeTypeDrop;
import org.dave.bonsaitrees.utility.Logz;

public class TreeTypeForestry
implements IBonsaiTreeType {
    private String name;
    ITree treeType;
    ItemStack exampleStack;
    private List<TreeTypeDrop> drops = new ArrayList<TreeTypeDrop>();

    public TreeTypeForestry(ITree treeType) {
        this.name = TreeTypeForestry.getCleanIdForTree(treeType);
        this.treeType = treeType;
    }

    public void addDrop(ItemStack stack, float chance) {
        this.drops.add(new TreeTypeDrop(stack.func_77946_l(), chance));
    }

    public ITree getForestryTreeType() {
        return this.treeType;
    }

    public static String getCleanIdForTree(ITree tree) {
        String modId = tree.getGenome().getPrimary().getModID();
        String treeId = tree.getGenome().getPrimary().getUnlocalizedName();
        if (modId.equals("forestry")) {
            treeId = treeId.replace("for.trees.species.", "");
        } else if (modId.equals("extratrees")) {
            treeId = treeId.replace("extratrees.species.", "");
            treeId = treeId.replace(".name", "");
        }
        return tree.getGenome().getPrimary().getModID() + ":" + treeId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<TreeTypeDrop> getDrops() {
        return this.drops;
    }

    @Override
    public Set<String> getCompatibleSoilTags() {
        return new HashSet<String>(Arrays.asList("dirt", "grass"));
    }

    @Override
    public boolean worksWith(ItemStack stack) {
        if (!TreeManager.treeRoot.isMember(stack)) {
            return false;
        }
        ITree forestryTree = TreeManager.treeRoot.getMember(stack);
        return this.getName().equals(TreeTypeForestry.getCleanIdForTree(forestryTree));
    }

    @Override
    public ItemStack getExampleStack() {
        if (this.exampleStack == null || this.exampleStack.func_190926_b()) {
            for (ITree forestryTree : TreeManager.treeRoot.getIndividualTemplates()) {
                if (!this.getName().equals(TreeTypeForestry.getCleanIdForTree(forestryTree))) continue;
                this.exampleStack = forestryTree.getGenome().getSpeciesRoot().getMemberStack((IIndividual)forestryTree, (ISpeciesType)EnumGermlingType.SAPLING);
            }
        }
        if (this.exampleStack == null) {
            Logz.info("Could not find example stack for tree: %s", this.getName());
            this.exampleStack = new ItemStack(Blocks.field_150345_g, 1, 0);
        }
        return this.exampleStack;
    }
}

