/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.trees;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.dave.bonsaitrees.trees.TreeShape;
import org.dave.bonsaitrees.utility.Logz;

public class TreeShapeSerializer
implements JsonDeserializer<TreeShape> {
    public TreeShape deserialize(JsonElement root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.isJsonObject()) {
            return null;
        }
        JsonObject rootObj = root.getAsJsonObject();
        int version = rootObj.has("version") ? rootObj.get("version").getAsInt() : 1;
        switch (version) {
            case 1: {
                return this.deserializeV1(rootObj, typeOfT, context);
            }
            case 2: {
                return this.deserializeV2(rootObj, typeOfT, context);
            }
        }
        Logz.warn("Invalid version in shape file: '%s', skipping shape! Maybe the shape file is from a newer mod version?", rootObj.get("version"));
        return null;
    }

    private Map<String, IBlockState> getReferenceMapV1(JsonObject jsonRefMap) {
        HashMap<String, IBlockState> refMap = new HashMap<String, IBlockState>();
        for (Map.Entry jsonRefEntry : jsonRefMap.entrySet()) {
            JsonObject jsonBlockInfo = ((JsonElement)jsonRefEntry.getValue()).getAsJsonObject();
            String blockName = jsonBlockInfo.get("name").getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            if (block == null) {
                Logz.warn("Invalid block '%s' used in shape", blockName);
                return null;
            }
            int blockMeta = jsonBlockInfo.has("meta") ? jsonBlockInfo.get("meta").getAsInt() : 0;
            IBlockState state = block.func_176203_a(blockMeta);
            refMap.put((String)jsonRefEntry.getKey(), state);
        }
        return refMap;
    }

    public TreeShape deserializeV2(JsonObject root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.has("type")) {
            Logz.warn("Missing type name in shape config", new Object[0]);
            return null;
        }
        String treeType = root.get("type").getAsString();
        Map<String, IBlockState> refMap = this.getReferenceMapV1(root.getAsJsonObject("ref"));
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        JsonArray jsonBlocks = root.getAsJsonArray("shape");
        int x = jsonBlocks.size() - 1;
        for (JsonElement zSliceElement : jsonBlocks) {
            int y = zSliceElement.getAsJsonArray().size() - 1;
            for (JsonElement ySliceElement : zSliceElement.getAsJsonArray()) {
                for (int z = 0; z < ySliceElement.getAsString().length(); ++z) {
                    String ref = ySliceElement.getAsString().charAt(z) + "";
                    if (ref.equals(" ")) continue;
                    if (!refMap.containsKey(ref)) {
                        Logz.warn("Shape-Entry is using an unknown block reference '%s'! Skipping shape!", ref);
                        return null;
                    }
                    blocks.put(new BlockPos(x, y, z), refMap.get(ref));
                }
                --y;
            }
            --x;
        }
        TreeShape result = new TreeShape(treeType);
        result.setBlocks(blocks);
        return result;
    }

    public TreeShape deserializeV1(JsonObject root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.has("type")) {
            Logz.warn("Missing type name in shape config", new Object[0]);
            return null;
        }
        String treeType = root.get("type").getAsString();
        Map<String, IBlockState> refMap = this.getReferenceMapV1(root.getAsJsonObject("ref"));
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        JsonArray jsonBlocks = root.getAsJsonArray("shape");
        for (JsonElement voxel : jsonBlocks) {
            if (!voxel.isJsonObject()) {
                Logz.warn("Shape-Array contains an element that is no object! Skipping shape!", new Object[0]);
                return null;
            }
            if (!voxel.getAsJsonObject().has("pos") || !voxel.getAsJsonObject().has("ref")) {
                Logz.warn("Shape-Entry is missing one of the required parameters 'pos' or 'ref'! Skipping shape!", new Object[0]);
                return null;
            }
            String refString = voxel.getAsJsonObject().get("ref").getAsString();
            if (!refMap.containsKey(refString)) {
                Logz.warn("Shape-Entry is using an unknown block reference! Skipping shape!", new Object[0]);
                return null;
            }
            JsonObject posJson = voxel.getAsJsonObject().get("pos").getAsJsonObject();
            int x = posJson.get("x").getAsInt();
            int y = posJson.get("y").getAsInt();
            int z = posJson.get("z").getAsInt();
            blocks.put(new BlockPos(x, y, z), refMap.get(refString));
        }
        TreeShape result = new TreeShape(treeType);
        result.setBlocks(blocks);
        return result;
    }

    public static String serializePretty(TreeShape shape) {
        int width = shape.getWidth() + 1;
        int height = shape.getHeight() + 1;
        int depth = shape.getDepth() + 1;
        if (width == 0 || height == 0 || depth == 0) {
            Logz.warn("Can not serialize tree shape for type: '%s', invalid dimensions: w=%d, h=%d, d=%d", shape.getTreeTypeName(), shape.getWidth(), shape.getHeight(), shape.getDepth());
            return null;
        }
        char[][][] map = new char[width][height][depth];
        StringBuilder refMapBuilder = new StringBuilder();
        refMapBuilder.append("  \"ref\": {\n");
        char nextRef = 'a';
        HashMap<String, Character> refMap = new HashMap<String, Character>();
        for (Map.Entry<BlockPos, IBlockState> entry : shape.getBlocks().entrySet()) {
            char thisRef;
            BlockPos pos = entry.getKey();
            IBlockState state = entry.getValue();
            String blockName = state.func_177230_c().getRegistryName().toString();
            int meta = state.func_177230_c().func_176201_c(state);
            String fullName = blockName + ":" + meta;
            if (refMap.containsKey(fullName)) {
                thisRef = ((Character)refMap.get(fullName)).charValue();
            } else {
                char c = nextRef;
                nextRef = (char)(nextRef + 1);
                thisRef = c;
                refMap.put(fullName, Character.valueOf(thisRef));
                refMapBuilder.append("    \"" + thisRef + "\": {\n");
                refMapBuilder.append("      \"name\": \"" + blockName + "\",\n");
                refMapBuilder.append("      \"meta\": " + meta + "\n");
                refMapBuilder.append("    },\n");
            }
            map[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = thisRef;
        }
        refMapBuilder.deleteCharAt(refMapBuilder.length() - 2);
        refMapBuilder.append("  },\n");
        StringBuilder output = new StringBuilder("{\n");
        output.append("  \"type\": \"" + shape.getTreeTypeName() + "\",\n");
        output.append("  \"version\": 2,\n");
        output.append((CharSequence)refMapBuilder);
        output.append("  \"shape\": [\n");
        for (int x = map.length - 1; x >= 0; --x) {
            output.append("    [\n");
            for (int y = map[x].length - 1; y >= 0; --y) {
                StringBuilder builder = new StringBuilder();
                for (int z = 0; z < map[x][y].length; ++z) {
                    char chr = ' ';
                    if (map[x][y][z] != '\u0000') {
                        chr = map[x][y][z];
                    }
                    builder.append(chr);
                }
                output.append("      \"" + builder + "\",\n");
            }
            output.deleteCharAt(output.length() - 2);
            output.append("    ],\n");
        }
        output.deleteCharAt(output.length() - 2);
        output.append("  ]\n}\n");
        return output.toString();
    }
}

