/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.vanilla;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.PredicateWrap;
import cd4017be.lib.util.OreDictStack;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreIngredient;

public class IngredientIterator
implements IOperand.OperandIterator {
    private final NonNullList<Ingredient> ingreds;
    private final ItemStack key;
    private final boolean shaped;
    private int idx = -1;
    private PredicateWrap<ItemStack> curElement;

    public IngredientIterator(NonNullList<Ingredient> rcp, ItemStack key, boolean shaped) {
        this.ingreds = rcp;
        this.key = key;
        this.shaped = shaped;
    }

    @Override
    public IOperand next() {
        return this.curElement;
    }

    @Override
    public void set(IOperand obj) {
        if (obj == this.curElement) {
            return;
        }
        if (obj instanceof ItemOperand) {
            this.ingreds.set(this.idx, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemOperand)obj).stack}));
        } else if (obj instanceof OreDictStack) {
            this.ingreds.set(this.idx, (Object)new OreIngredient(((OreDictStack)obj).id));
        } else if (obj == Nil.NIL) {
            if (this.shaped) {
                this.ingreds.set(this.idx, (Object)Ingredient.field_193370_a);
            } else {
                this.ingreds.remove(this.idx--);
            }
        } else {
            throw new IllegalArgumentException("exp. ItemStack or OreDictStack");
        }
    }

    @Override
    public boolean hasNext() {
        while (++this.idx < this.ingreds.size()) {
            Ingredient ingr = (Ingredient)this.ingreds.get(this.idx);
            if (this.key != null && !ingr.apply(this.key)) continue;
            this.curElement = new PredicateWrap<ItemStack>((Predicate<ItemStack>)ingr, ItemStack.class);
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.idx = -1;
    }

    @Override
    public Object value() {
        return this;
    }
}

