/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.interact;

import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public interface IInteractiveComponent {
    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d var1, Vec3d var2);

    public boolean onInteract(EntityPlayer var1, boolean var2, EnumFacing var3, Vec3d var4);

    public Pair<Vec3d, String> getDisplayText(Vec3d var1);

    public static Pair<Vec3d, EnumFacing> rayTraceFlat(Vec3d start, Vec3d dir, Vec3d pos, EnumFacing side, float width, float height) {
        double d;
        double dx = pos.field_72450_a - start.field_72450_a;
        double dy = pos.field_72448_b - start.field_72448_b;
        double dz = pos.field_72449_c - start.field_72449_c;
        switch (side) {
            case DOWN: 
            case UP: {
                d = dy / dir.field_72448_b;
                if (d <= 0.0 || d > 1.0 || Math.abs(dx - dir.field_72450_a * d) > (double)width || Math.abs(dz - dir.field_72449_c * d) > (double)height) {
                    return null;
                }
                side = dy > 0.0 ? EnumFacing.DOWN : EnumFacing.UP;
                break;
            }
            case NORTH: 
            case SOUTH: {
                d = dz / dir.field_72449_c;
                if (d < 0.0 || d > 1.0 || Math.abs(dx - dir.field_72450_a * d) > (double)width || Math.abs(dy - dir.field_72448_b * d) > (double)height) {
                    return null;
                }
                side = dz > 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                break;
            }
            case WEST: 
            case EAST: {
                d = dx / dir.field_72450_a;
                if (d < 0.0 || d > 1.0 || Math.abs(dy - dir.field_72448_b * d) > (double)height || Math.abs(dz - dir.field_72449_c * d) > (double)width) {
                    return null;
                }
                side = dx > 0.0 ? EnumFacing.WEST : EnumFacing.EAST;
                break;
            }
            default: {
                return null;
            }
        }
        return Pair.of((Object)dir.func_186678_a(d), (Object)side);
    }

    public static interface ITESRenderComp {
        @SideOnly(value=Side.CLIENT)
        public void render(World var1, BlockPos var2, double var3, double var5, double var7, int var9, BufferBuilder var10);

        public AxisAlignedBB getRenderBB(World var1, BlockPos var2);
    }

    public static interface IBlockRenderComp {
        @SideOnly(value=Side.CLIENT)
        public void render(List<BakedQuad> var1);
    }
}

