/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Lib;
import cd4017be.lib.block.BaseBlock;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerBlock;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.property.PropertyBlockMimic;
import cd4017be.lib.property.PropertyWrapObj;
import cd4017be.lib.templates.Cover;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedBlock
extends BaseBlock
implements IGuiHandlerBlock {
    public final Class<? extends TileEntity> tileEntity;
    protected EnumBlockRenderType renderType;
    protected AxisAlignedBB[] boundingBox;
    protected int flags;
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);
    protected static final Set<IProperty<?>> L_PROPERTIES = new HashSet();
    protected static final Set<IUnlistedProperty<?>> UL_PROPERTIES = new HashSet();
    private BlockRenderLayer blockLayer = BlockRenderLayer.SOLID;
    public Class<? extends Container> container;
    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> guiScreen;

    private static String initProperties(String id, Class<? extends TileEntity> tile) {
        if (MultipartBlock.IModularTile.class.isAssignableFrom(tile)) {
            UL_PROPERTIES.add(PropertyWrapObj.MULTIPART);
        }
        if (ICoverableTile.class.isAssignableFrom(tile)) {
            UL_PROPERTIES.add(PropertyWrapObj.COVER);
        }
        return id;
    }

    public AdvancedBlock(String id, Material m, SoundType sound, int flags, @Nullable Class<? extends TileEntity> tile) {
        super(AdvancedBlock.initProperties(id, tile), m);
        L_PROPERTIES.clear();
        UL_PROPERTIES.clear();
        this.func_149672_a(sound);
        this.field_149787_q = (flags & 1) == 0;
        this.flags = flags << 15;
        this.tileEntity = tile;
        if (tile != null) {
            if (INeighborAwareTile.class.isAssignableFrom(tile)) {
                this.flags |= 1;
            }
            if (ISelfAwareTile.class.isAssignableFrom(tile)) {
                this.flags |= 2;
            }
            if (IInteractiveTile.class.isAssignableFrom(tile)) {
                this.flags |= 4;
            }
            if (ITilePlaceHarvest.class.isAssignableFrom(tile)) {
                this.flags |= 8;
            }
            if (IRedstoneTile.class.isAssignableFrom(tile)) {
                this.flags |= 0x10;
            }
            if (ITileCollision.class.isAssignableFrom(tile)) {
                this.flags |= 0x20;
            }
            if ((flags & 4) == 0 && (DataContainer.IGuiData.class.isAssignableFrom(tile) || IGuiHandlerTile.class.isAssignableFrom(tile))) {
                this.flags |= 0x40;
            }
            if (IComparatorSource.class.isAssignableFrom(tile)) {
                this.flags |= 0x80;
            }
            if (MultipartBlock.IModularTile.class.isAssignableFrom(tile)) {
                this.flags |= 0x100;
            }
            if (TileEntity.func_190559_a(tile) == null) {
                GameRegistry.registerTileEntity(this.tileEntity, (ResourceLocation)this.getRegistryName());
            }
        }
        this.renderType = EnumBlockRenderType.MODEL;
        this.boundingBox = new AxisAlignedBB[]{field_185505_j};
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, L_PROPERTIES.toArray(new IProperty[L_PROPERTIES.size()]), UL_PROPERTIES.toArray(new IUnlistedProperty[UL_PROPERTIES.size()]));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover;
        if ((this.flags & 0x100) == 0) {
            return state;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MultipartBlock.IModularTile)) {
            return state;
        }
        IExtendedBlockState eState = ((IExtendedBlockState)state).withProperty(PropertyWrapObj.MULTIPART, (Object)((MultipartBlock.IModularTile)te));
        if (te instanceof ICoverableTile && (cover = ((ICoverableTile)te).getCover().state) != null) {
            try {
                eState = eState.withProperty((IUnlistedProperty)PropertyBlockMimic.instance, (Object)cover.func_177230_c().getExtendedState(cover.func_185899_b(world, pos), world, pos));
            }
            catch (IllegalArgumentException e) {
                eState = eState.withProperty((IUnlistedProperty)PropertyBlockMimic.instance, (Object)cover);
            }
        }
        return eState;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.tileEntity != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.tileEntity != null) {
            try {
                try {
                    return this.tileEntity.getConstructor(IBlockState.class).newInstance(state);
                }
                catch (NoSuchMethodException e) {
                    return this.tileEntity.newInstance();
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block b, BlockPos src) {
        if ((this.flags & 1) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof INeighborAwareTile) {
            ((INeighborAwareTile)te).neighborBlockChange(b, src);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if ((this.flags & 2) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ISelfAwareTile) {
            ((ISelfAwareTile)te).breakBlock();
        }
        world.func_175713_t(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing s, float X, float Y, float Z) {
        TileEntity te;
        if ((this.flags & 4) != 0 && (te = world.func_175625_s(pos)) instanceof IInteractiveTile && ((IInteractiveTile)te).onActivated(player, hand, player.func_184586_b(hand), s, X, Y, Z)) {
            return true;
        }
        if ((this.flags & 0x40) != 0) {
            BlockGuiHandler.OPEN_CLIENT = this.container != null;
            GuiNetworkHandler.openBlockGui(player, pos, 0);
            BlockGuiHandler.OPEN_CLIENT = false;
            return true;
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if ((this.flags & 4) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInteractiveTile) {
            ((IInteractiveTile)te).onClicked(player);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack item) {
        if ((this.flags & 8) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITilePlaceHarvest) {
            ((ITilePlaceHarvest)te).onPlaced(entity, item);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        if ((this.flags & 8) != 0 && !world.field_72995_K && !world.restoringBlockSnapshots) {
            Item item = this.func_180660_a(state, RANDOM, 0);
            int dmg = this.func_180651_a(state);
            for (ItemStack stack : this.getDrops((IBlockAccess)world, pos, state, 0)) {
                if (stack.func_77973_b() == item && stack.func_77952_i() == dmg && !stack.func_77942_o()) continue;
                AdvancedBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if ((this.flags & 8) == 0) {
            return super.getDrops(world, pos, state, fortune);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITilePlaceHarvest) {
            return ((ITilePlaceHarvest)te).dropItem(state, fortune);
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean func_149744_f(IBlockState state) {
        return (this.flags & 0x10) != 0;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (this.flags & 0x10) == 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        if ((this.flags & 0x10) == 0) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IRedstoneTile) {
            return ((IRedstoneTile)te).redstoneLevel(s.func_176734_d(), false);
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        if ((this.flags & 0x10) == 0) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IRedstoneTile) {
            return ((IRedstoneTile)te).redstoneLevel(s.func_176734_d(), true);
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if ((this.flags & 0x10) == 0) {
            return false;
        }
        if (side == null) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IRedstoneTile) {
            return ((IRedstoneTile)te).connectRedstone(side.func_176734_d());
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return (this.flags & 0x80) != 0;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        if ((this.flags & 0x80) == 0) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IComparatorSource) {
            return ((IComparatorSource)te).comparatorValue();
        }
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if ((this.flags & 0x20) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITileCollision) {
            ((ITileCollision)te).onEntityCollided(entity);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return (this.flags & 0x10000) == 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.boundingBox[0] == field_185505_j;
    }

    public boolean func_149721_r(IBlockState state) {
        return this.boundingBox[0] == field_185505_j;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos) == field_185505_j;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        AxisAlignedBB box = this.func_185496_a(state, world, pos);
        if (box == field_185505_j) {
            return true;
        }
        return AdvancedBlock.getFace(box, side) == (side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1.0 : 0.0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        BlockFaceShape shape;
        AxisAlignedBB box = this.getBBWithoutCover(state, world, pos);
        if (box == field_185505_j) {
            return BlockFaceShape.SOLID;
        }
        IBlockState cover = this.getCover(world, pos);
        if (cover != null && (shape = cover.func_193401_d(world, pos, side)) != BlockFaceShape.UNDEFINED) {
            return shape;
        }
        if (box == field_185506_k) {
            return BlockFaceShape.UNDEFINED;
        }
        double radA = 1.0;
        double radB = 1.0;
        int o = 3 - (side.ordinal() >> 1);
        for (EnumFacing f : EnumFacing.values()) {
            if (f == side.func_176734_d()) continue;
            double d = AdvancedBlock.getFace(box, f) / 2.0 * (double)f.func_176743_c().func_179524_a();
            if (d < 0.0625 || f == side && d < 0.5) {
                return BlockFaceShape.UNDEFINED;
            }
            if (((f.ordinal() >> 1) + o) % 3 == 1) {
                if (!(d < radA)) continue;
                radA = d;
                continue;
            }
            if (!(d < radB)) continue;
            radB = d;
        }
        if (radB > radA) {
            double r = radB;
            radB = radA;
            radA = r;
        }
        return radA < 0.5 ? (radB >= 0.25 ? BlockFaceShape.CENTER_BIG : (radB >= 0.125 ? BlockFaceShape.CENTER : BlockFaceShape.CENTER_SMALL)) : (radB < 0.5 ? (radB >= 0.25 ? BlockFaceShape.MIDDLE_POLE_THICK : (radB >= 0.125 ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.MIDDLE_POLE_THIN)) : BlockFaceShape.SOLID);
    }

    private static double getFace(AxisAlignedBB box, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return box.field_72338_b;
            }
            case UP: {
                return box.field_72337_e;
            }
            case NORTH: {
                return box.field_72339_c;
            }
            case SOUTH: {
                return box.field_72334_f;
            }
            case WEST: {
                return box.field_72340_a;
            }
            case EAST: {
                return box.field_72336_d;
            }
        }
        return Double.NaN;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.func_149721_r(state);
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void setRenderType(EnumBlockRenderType t) {
        this.renderType = t;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.renderType;
    }

    public void setBlockLayer(BlockRenderLayer layer) {
        this.blockLayer = layer;
    }

    public BlockRenderLayer func_180664_k() {
        return this.blockLayer;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.blockLayer == null || layer == this.blockLayer;
    }

    public AdvancedBlock setBlockBounds(AxisAlignedBB box) {
        this.boundingBox[0] = box;
        return this;
    }

    protected AxisAlignedBB getMainBB(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.boundingBox[0];
    }

    protected AxisAlignedBB getBBWithoutCover(IBlockState state, IBlockAccess world, BlockPos pos) {
        AxisAlignedBB box = this.getMainBB(state, world, pos);
        if (box == field_185505_j || (this.flags & 0x100) == 0) {
            return box;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartBlock.IModularTile) {
            MultipartBlock.IModularTile tile = (MultipartBlock.IModularTile)te;
            for (int i = 1; i < this.boundingBox.length; ++i) {
                AxisAlignedBB box1 = this.boundingBox[i];
                if (box1 == field_185506_k || !tile.isModulePresent(i - 1)) continue;
                if (box1 == field_185505_j) {
                    return box1;
                }
                box = box == field_185506_k ? box1 : box.func_111270_a(box1);
            }
        }
        return box;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        AxisAlignedBB box = this.getBBWithoutCover(state, world, pos);
        if (box == field_185505_j) {
            return box;
        }
        IBlockState cover = this.getCover(world, pos);
        if (cover != null) {
            AxisAlignedBB box1 = cover.func_185900_c(world, pos);
            if (box1 == field_185505_j) {
                return box1;
            }
            box = box == field_185506_k ? box1 : box.func_111270_a(box1);
        }
        return box == field_185506_k ? EMPTY_AABB : box;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> list, Entity entity, boolean b) {
        TileEntity te;
        if ((this.flags & 0x100) == 0) {
            super.func_185477_a(state, world, pos, entityBox, list, entity, b);
            return;
        }
        AxisAlignedBB box = this.getMainBB(state, (IBlockAccess)world, pos);
        AdvancedBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, list, (AxisAlignedBB)box);
        if (box == field_185505_j) {
            return;
        }
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover != null) {
            cover.func_185908_a(world, pos, entityBox, list, entity, false);
        }
        if ((te = world.func_175625_s(pos)) instanceof MultipartBlock.IModularTile) {
            MultipartBlock.IModularTile tile = (MultipartBlock.IModularTile)te;
            for (int i = 1; i < this.boundingBox.length; ++i) {
                box = this.boundingBox[i];
                if (box == field_185506_k || !tile.isModulePresent(i - 1)) continue;
                AdvancedBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, list, (AxisAlignedBB)box);
                if (box != field_185505_j) continue;
                return;
            }
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult rtr;
        IBlockState cover;
        if ((this.flags & 0x100) == 0) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        Vec3d start1 = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d end1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        int p = 0;
        RayTraceResult collision = null;
        AxisAlignedBB box = this.getMainBB(state, (IBlockAccess)world, pos);
        if (box != field_185506_k && (collision = box.func_72327_a(start1, end1)) != null) {
            end1 = collision.field_72307_f;
        }
        if (box != field_185505_j) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof MultipartBlock.IModularTile) {
                MultipartBlock.IModularTile tile = (MultipartBlock.IModularTile)te;
                for (int i = 1; i < this.boundingBox.length; ++i) {
                    box = this.boundingBox[i];
                    if (box == field_185506_k || !tile.isModulePresent(i - 1)) continue;
                    RayTraceResult collision1 = box.func_72327_a(start1, end1);
                    if (collision1 != null) {
                        collision = collision1;
                        end1 = collision.field_72307_f;
                        p = i;
                    }
                    if (box == field_185505_j) break;
                }
            }
            cover = this.getCover((IBlockAccess)world, pos);
        } else {
            cover = null;
        }
        if (collision != null) {
            end = end1.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            collision = new RayTraceResult(end, collision.field_178784_b, pos);
            collision.subHit = p;
        }
        if (cover != null && (rtr = cover.func_185910_a(world, pos, start, end)) != null) {
            rtr.subHit = -2;
            return rtr;
        }
        return collision;
    }

    protected IBlockState getCover(IBlockAccess world, BlockPos pos) {
        if ((this.flags & 0x100) == 0) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ICoverableTile && te.func_145838_q() == this) {
            return ((ICoverableTile)te).getCover().state;
        }
        return null;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover == null) {
            return this.field_149782_v;
        }
        float h = cover.func_185887_b(world, pos);
        return h < 0.0f ? h : h + this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        float r = this.field_149781_w / 5.0f;
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover != null) {
            try {
                r += cover.func_177230_c().getExplosionResistance(world, pos, exploder, explosion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return r;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        IBlockState cover = this.getCover(world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().canEntityDestroy(cover, world, pos, entity);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        if (cover == null) {
            return this.field_149784_t;
        }
        return Math.max(this.field_149784_t, cover.func_185906_d());
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        if (cover == null) {
            return this.field_149786_r;
        }
        return Math.max(this.field_149786_r, cover.getLightOpacity(world, pos));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (super.doesSideBlockRendering(state, world, pos, face)) {
            return true;
        }
        IBlockState cover = this.getCover(world, pos);
        return cover != null && cover.doesSideBlockRendering(world, pos, face);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState cover = this.getCover(world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().canBeConnectedTo(world, pos, facing);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().getSoundType(cover, world, pos, entity);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.field_149762_H;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().canSustainLeaves(cover, world, pos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState cover = this.getCover(world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().canSustainPlant(cover, world, pos, direction, plantable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().isBurning(world, pos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover != null) {
            try {
                return cover.func_177230_c().isFireSource(world, pos, side);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Container getContainer(IBlockState state, World world, BlockPos pos, EntityPlayer player, int id) {
        Container c;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IGuiHandlerTile) {
            return ((IGuiHandlerTile)te).getContainer(player, id);
        }
        if (this.container != null && te instanceof DataContainer.IGuiData) {
            try {
                c = this.container.getConstructor(DataContainer.IGuiData.class, EntityPlayer.class).newInstance((DataContainer.IGuiData)te, player);
            }
            catch (NoSuchMethodException ex) {
                Lib.LOG.warn("TileContainer {} is missing the Constructor ({} ,{})", (Object)this.container.getName(), (Object)DataContainer.IGuiData.class.getName(), (Object)EntityPlayer.class.getName());
                return null;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            return null;
        }
        if (c instanceof DataContainer) {
            ((DataContainer)c).data.initContainer((DataContainer)c);
        }
        return c;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiScreen(IBlockState state, World world, BlockPos pos, EntityPlayer player, int id) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IGuiHandlerTile) {
            return ((IGuiHandlerTile)te).getGuiScreen(player, id);
        }
        if (this.guiScreen != null && te instanceof DataContainer.IGuiData) {
            if (player.field_71070_bA != null && player.field_71070_bA instanceof DataContainer && ((DataContainer)player.field_71070_bA).data == te) {
                return Minecraft.func_71410_x().field_71462_r;
            }
            try {
                GuiScreen g = this.guiScreen.getConstructor(DataContainer.IGuiData.class, EntityPlayer.class).newInstance((DataContainer.IGuiData)te, player);
                if (g instanceof GuiContainer && ((GuiContainer)g).field_147002_h instanceof DataContainer) {
                    DataContainer c = (DataContainer)((GuiContainer)g).field_147002_h;
                    c.data.initContainer(c);
                    c.refInts = c.data.getSyncVariables();
                    if (c.refInts != null && c.data instanceof TileEntity) {
                        for (int i = 0; i < c.refInts.length; ++i) {
                            c.data.setSyncVariable(i, 0);
                        }
                    }
                }
                return g;
            }
            catch (NoSuchMethodException ex) {
                Lib.LOG.warn("GuiContainer {} is missing the Constructor ({} ,{})", (Object)this.guiScreen.getName(), (Object)DataContainer.IGuiData.class.getName(), (Object)EntityPlayer.class.getName());
                return null;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static interface ICoverableTile
    extends MultipartBlock.IModularTile,
    IInteractiveTile {
        public Cover getCover();

        @Override
        default public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
            return this.getCover().interact((BaseTileEntity)((Object)this), player, hand, item, s, X, Y, Z);
        }

        @Override
        default public void onClicked(EntityPlayer player) {
            this.getCover().hit((BaseTileEntity)((Object)this), player);
        }

        @Override
        default public <T> T getModuleState(int m) {
            return (T)this.getCover().module();
        }

        @Override
        default public boolean isModulePresent(int m) {
            return false;
        }

        @Override
        default public boolean isOpaque() {
            return this.getCover().opaque;
        }
    }

    public static interface ITileCollision {
        public void onEntityCollided(Entity var1);
    }

    public static interface IComparatorSource {
        public int comparatorValue();
    }

    public static interface IRedstoneTile {
        public int redstoneLevel(EnumFacing var1, boolean var2);

        public boolean connectRedstone(EnumFacing var1);
    }

    public static interface ITilePlaceHarvest {
        public void onPlaced(EntityLivingBase var1, ItemStack var2);

        public List<ItemStack> dropItem(IBlockState var1, int var2);
    }

    public static interface IInteractiveTile {
        public boolean onActivated(EntityPlayer var1, EnumHand var2, ItemStack var3, EnumFacing var4, float var5, float var6, float var7);

        public void onClicked(EntityPlayer var1);
    }

    public static interface ISelfAwareTile {
        public void breakBlock();
    }

    public static interface INeighborAwareTile {
        public void neighborBlockChange(Block var1, BlockPos var2);

        public void neighborTileChange(TileEntity var1, EnumFacing var2);
    }
}

