/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockFluidWrapper
implements IFluidHandler {
    private World world;
    private BlockPos pos;
    private IBlockState state;

    public BlockFluidWrapper set(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.state = null;
        return this;
    }

    private IBlockState block() {
        return this.state != null ? this.state : (this.state = this.world.func_180495_p(this.pos));
    }

    public IFluidTankProperties[] getTankProperties() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        IBlockState state = this.block();
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).place(this.world, this.pos, resource, doFill);
        }
        if (resource.amount < 1000) {
            return 0;
        }
        Material m = state.func_185904_a();
        if (!m.func_76222_j() || m.func_76224_d() && state == block.func_176223_P()) {
            return 0;
        }
        if (doFill) {
            this.world.func_175655_b(this.pos, true);
            this.world.func_180501_a(this.pos, resource.getFluid().getBlock().func_176223_P(), 3);
        }
        return 1000;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack stack = this.drain(resource.amount, false);
        if (!resource.containsFluid(stack)) {
            return null;
        }
        if (doDrain) {
            return this.drain(resource.amount, true);
        }
        return stack;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        Fluid fluid;
        IBlockState state = this.block();
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).drain(this.world, this.pos, doDrain);
        }
        if (maxDrain < 1000 || state != block.func_176223_P()) {
            return null;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            fluid = FluidRegistry.WATER;
        } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            fluid = FluidRegistry.LAVA;
        } else {
            return null;
        }
        if (doDrain) {
            this.world.func_175698_g(this.pos);
        }
        return new FluidStack(fluid, 1000);
    }
}

