/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import cd4017be.lib.jvm_utils.ClassAssembler;
import cd4017be.lib.jvm_utils.ConstantPool;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class ClassUtils {
    public static final String NAME_BASE = "cd4017be.generated.C_";
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final HashFunction hashfunc = Hashing.murmur3_128();
    static final HashMap<UUID, String> registered = new HashMap();
    static int lastIdx = 0;

    public static String registerUnnamed(UUID uuid, Function<String, byte[]> generator) {
        String name = registered.get(uuid);
        if (name != null) {
            return name;
        }
        name = NAME_BASE + Integer.toHexString(lastIdx++);
        registered.put(uuid, name);
        ClassAssembler.INSTANCE.register(name, generator);
        return name;
    }

    public static UUID hash(String tag, byte[] data) {
        HashCode hash;
        if (tag != null) {
            byte[] typeb = tag.getBytes(UTF8);
            hash = hashfunc.newHasher(data.length + typeb.length).putBytes(typeb).putBytes(data).hash();
        } else {
            hash = hashfunc.hashBytes(data);
        }
        ByteBuffer buf = ByteBuffer.wrap(hash.asBytes());
        return new UUID(buf.getLong(), buf.getLong());
    }

    public static Function<String, byte[]> generator(List<Class<?>> interfaces, ConstantPool cpt, List<byte[]> fields, List<byte[]> methods, Map<Short, byte[]> attributes) {
        return name -> {
            cpt.setUtf8(1, name.replace('.', '/'));
            return ClassAssembler.genClass(interfaces, cpt, fields, methods, attributes);
        };
    }

    public static <T> T makeInstance(String name, Class<T> type) {
        try {
            return type.cast(Class.forName(name, true, ClassAssembler.INSTANCE).newInstance());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (ClassFormatError | VerifyError e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getClassOrNull(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method getMethodOrNull(Class<?> owner, String name, Class<?> ... args) {
        try {
            return owner == null ? null : owner.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Field getFieldOrNull(Class<?> owner, String name) {
        if (owner == null) {
            return null;
        }
        try {
            Field f = owner.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

