/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Context;
import cd4017be.lib.script.Function;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptFiles;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.script.ScriptException;

public class Compiler {
    private static ByteBuffer buffer = ByteBuffer.allocate(65536);
    private Iterator<Comp> code;
    private HashMap<String, Function> functions = new HashMap();
    private HashMap<String, IOperand> globals = new HashMap();
    public final String fileName;

    public static void deallocate() {
        buffer = null;
    }

    public static Script compile(Context cont, String name, Reader script) throws ScriptException {
        Compiler c = new Compiler(name, Compiler.parse(name, script));
        Script sc = c.compile();
        cont.add(sc);
        return sc;
    }

    public Compiler(String fileName, List<Comp> code) {
        this.fileName = fileName;
        this.code = code.iterator();
    }

    public static ArrayList<Comp> parse(String name, Reader script) throws ScriptException {
        LineTracker code = new LineTracker(script);
        try {
            try {
                boolean read = true;
                int c = code.next();
                while (c >= 0) {
                    switch (c) {
                        case 59: {
                            code.add(new Comp(Type.sep_cmd));
                            break;
                        }
                        case 44: {
                            code.add(new Comp(Type.sep_par));
                            break;
                        }
                        case 40: {
                            code.add(new Comp(Type.B_par));
                            break;
                        }
                        case 41: {
                            code.add(new Comp(Type.E_par));
                            break;
                        }
                        case 91: {
                            code.add(new Comp(Type.B_list));
                            break;
                        }
                        case 93: {
                            code.add(new Comp(Type.E_list));
                            break;
                        }
                        case 123: {
                            code.add(new Comp(Type.B_block));
                            break;
                        }
                        case 125: {
                            code.add(new Comp(Type.E_block));
                            break;
                        }
                        case 61: {
                            c = code.next();
                            if (c == 61) {
                                code.add(new Comp(Type.op_eq));
                                break;
                            }
                            read = false;
                            code.add(new Comp(Type.op_asn));
                            break;
                        }
                        case 60: {
                            c = code.next();
                            if (c == 61) {
                                code.add(new Comp(Type.op_ngr));
                                break;
                            }
                            read = false;
                            code.add(new Comp(Type.op_ls));
                            break;
                        }
                        case 62: {
                            c = code.next();
                            if (c == 61) {
                                code.add(new Comp(Type.op_nls));
                                break;
                            }
                            read = false;
                            code.add(new Comp(Type.op_gr));
                            break;
                        }
                        case 126: {
                            c = code.next();
                            if (c == 61) {
                                code.add(new Comp(Type.op_neq));
                                break;
                            }
                            if (c == 38) {
                                code.add(new Comp(Type.op_nand));
                                break;
                            }
                            if (c == 124) {
                                code.add(new Comp(Type.op_nor));
                                break;
                            }
                            if (c == 63) {
                                code.add(new Comp(Type.op_xnor));
                                break;
                            }
                            read = false;
                            code.add(new Comp(Type.op_not));
                            break;
                        }
                        case 38: {
                            code.add(new Comp(Type.op_and));
                            break;
                        }
                        case 124: {
                            code.add(new Comp(Type.op_or));
                            break;
                        }
                        case 63: {
                            code.add(new Comp(Type.op_xor));
                            break;
                        }
                        case 43: {
                            code.add(new Comp(Type.op_add));
                            break;
                        }
                        case 45: {
                            code.add(new Comp(Type.op_sub));
                            break;
                        }
                        case 42: {
                            code.add(new Comp(Type.op_mul));
                            break;
                        }
                        case 47: {
                            code.add(new Comp(Type.op_div));
                            break;
                        }
                        case 37: {
                            code.add(new Comp(Type.op_mod));
                            break;
                        }
                        case 94: {
                            code.add(new Comp(Type.op_pow));
                            break;
                        }
                        case 35: {
                            code.add(new Comp(Type.op_num));
                            break;
                        }
                        case 58: {
                            code.add(new Comp(Type.op_ind));
                            break;
                        }
                        case 36: {
                            code.add(new Comp(Type.op_text));
                            break;
                        }
                        case 34: {
                            String s = "";
                            while (true) {
                                if ((c = code.next()) == 92) {
                                    c = code.next();
                                    if (c == 110) {
                                        c = 10;
                                    } else if (c == 116) {
                                        c = 9;
                                    }
                                } else if (c == 34) break;
                                if (c < 0) break;
                                s = s + (char)c;
                            }
                            code.add(new ConstValue(new Text(s)));
                            break;
                        }
                        case 33: {
                            while ((c = code.next()) >= 0 && c != 10) {
                            }
                            break;
                        }
                        default: {
                            String s;
                            if (c >= 48 && c <= 57) {
                                s = "" + (char)c;
                                while ((c = code.next()) >= 0) {
                                    if (c >= 48 && c <= 57 || c == 46 || c == 101) {
                                        s = s + (char)c;
                                        continue;
                                    }
                                    read = false;
                                    break;
                                }
                                try {
                                    double x = Double.parseDouble(s);
                                    if (code.prev((int)-1).type == Type.op_div && Compiler.canInv(code.prev((int)-2).type)) {
                                        code.remPrev();
                                        x = 1.0 / x;
                                    }
                                    if (code.prev((int)-1).type == Type.op_sub && Compiler.canInv(code.prev((int)-2).type)) {
                                        code.remPrev();
                                        x = -x;
                                    }
                                    code.add(new ConstValue(new Number(x)));
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    throw new ScriptException("illegal number format: " + s, name, code.line, code.col);
                                }
                            }
                            if (Character.isJavaIdentifierStart(c)) {
                                s = "" + (char)c;
                                boolean comp = false;
                                while ((c = code.next()) >= 0) {
                                    if (Character.isJavaIdentifierPart(c)) {
                                        s = s + (char)c;
                                        continue;
                                    }
                                    if (c == 46) {
                                        s = s + (char)c;
                                        comp = true;
                                        continue;
                                    }
                                    read = false;
                                    break;
                                }
                                if ("nil".equals(s)) {
                                    code.add(new ConstValue(Nil.NIL));
                                    break;
                                }
                                if ("false".equals(s)) {
                                    code.add(new ConstValue(Number.FALSE));
                                    break;
                                }
                                if ("true".equals(s)) {
                                    code.add(new ConstValue(Number.TRUE));
                                    break;
                                }
                                if ("NaN".equals(s)) {
                                    code.add(new ConstValue(Number.NAN));
                                    break;
                                }
                                if ("fail".equals(s)) {
                                    code.add(new Comp(Type.K_fail));
                                    break;
                                }
                                if ("if".equals(s)) {
                                    code.add(new Comp(Type.K_if));
                                    break;
                                }
                                if ("else".equals(s)) {
                                    code.add(new Comp(Type.K_else));
                                    break;
                                }
                                if ("for".equals(s)) {
                                    code.add(new Comp(Type.K_for));
                                    break;
                                }
                                if ("return".equals(s)) {
                                    code.add(new Comp(Type.K_ret));
                                    break;
                                }
                                if ("break".equals(s)) {
                                    code.add(new Comp(Type.K_br));
                                    break;
                                }
                                if ("continue".equals(s)) {
                                    code.add(new Comp(Type.K_cont));
                                    break;
                                }
                                if ("Loc".equals(s)) {
                                    code.add(new Comp(Type.K_loc));
                                    break;
                                }
                                code.add(new Identifier(s, comp));
                                break;
                            }
                            if (Character.isWhitespace(c)) break;
                            throw new ScriptException("unexpected character: " + (char)c, name, code.line, code.col);
                        }
                    }
                    if (read) {
                        c = code.next();
                        continue;
                    }
                    read = true;
                }
                code.reader.close();
            }
            catch (ScriptException e) {
                code.reader.close();
                throw e;
            }
        }
        catch (IOException e) {
            throw new ScriptException("[IO-Err] " + e.getMessage());
        }
        return code.parsed;
    }

    private static boolean canInv(Type t) {
        switch (t) {
            case val: 
            case id: 
            case op_num: 
            case E_par: 
            case E_list: {
                return false;
            }
        }
        return true;
    }

    public Script compile() throws ScriptException {
        while (this.code.hasNext()) {
            Comp c = this.code.next();
            try {
                if (c.type == Type.B_block) {
                    Function func = this.compFunc(this.fileName, true);
                    func.script = new Script(this.fileName, new HashMap<String, Function>(), this.globals);
                    func.apply(new Parameters(new IOperand[0]));
                    continue;
                }
                this.check(c, Type.id);
                if (((Identifier)c).com) {
                    throw new ScriptException("invalid identifier", this.fileName, c.line, c.col);
                }
                String name = ((Identifier)c).id;
                Comp c1 = this.code.next();
                if (c1.type == Type.op_asn) {
                    c1 = this.code.next();
                    this.check(c1, Type.val);
                    this.globals.put(name, ((ConstValue)c1).val);
                    this.check(this.code.next(), Type.sep_cmd);
                    continue;
                }
                if (c1.type == Type.B_par) {
                    this.functions.put(name, this.compFunc(this.fileName + "." + name, false));
                    continue;
                }
                throw new ScriptException("exp. assignment or function header", this.fileName, c1.line, c1.col);
            }
            catch (NoSuchElementException e) {
                throw new ScriptException("unexpected end of file!", this.fileName, c.line, c.col);
            }
        }
        Script script = new Script(this.fileName, this.functions, this.globals);
        IOperand v = this.globals.remove("VERSION");
        if (v != null) {
            script.version = v.asIndex();
        }
        return script;
    }

    private Function compFunc(String name, boolean root) throws ScriptException {
        State state = new State(name);
        if (root) {
            state.lineOfs = 0;
        } else {
            while (true) {
                Comp id = this.code.next();
                if (id.type == Type.E_par) break;
                this.check(id, Type.id);
                if (((Identifier)id).com) {
                    state.err("invalid identifier", id);
                }
                state.regVar(((Identifier)id).id);
                Comp sep = this.code.next();
                if (sep.type == Type.E_par) break;
                this.check(sep, Type.sep_par);
            }
            Comp c = state.next(Type.B_block);
            state.lineOfs = c.line;
        }
        int param = state.lastId;
        buffer.rewind();
        boolean st = this.compBlock(state);
        int p = buffer.position() - (st ? 2 : 0);
        for (int i : state.returnPos) {
            buffer.putShort(i, (short)p);
        }
        byte[] data = new byte[p];
        buffer.rewind();
        buffer.get(data);
        return new Function(param, state.maxStack, state.lineOfs, data, state.hasRet, name, state.lines);
    }

    private boolean compBlock(State state) throws ScriptException {
        int variables;
        block40: {
            Comp c;
            int lastIf = -1;
            int lastElse = -1;
            variables = state.lastId;
            block10: while (true) {
                c = this.code.next();
                if (c.type == Type.E_block) break block40;
                state.curStack = 0;
                switch (c.type) {
                    case id: {
                        String name = ((Identifier)c).id;
                        Comp c1 = this.code.next();
                        if (c1.type == Type.op_asn) {
                            c1 = this.eval(state, null);
                            this.check(c1, Type.sep_cmd);
                            Byte p = state.varIds.get(name);
                            if (p != null) {
                                state.op((byte)2, c1);
                                buffer.put(p);
                                continue block10;
                            }
                            state.op((byte)3, c1);
                            Function.putName(buffer, name, false);
                            continue block10;
                        }
                        if (c1.type == Type.op_ind) {
                            Byte p = state.varIds.get(name);
                            if (p != null) {
                                state.op((byte)0, c1);
                                buffer.put(p);
                            } else {
                                state.op((byte)1, c1);
                                Function.putName(buffer, name, false);
                            }
                            c1 = this.eval(state, null);
                            this.check(c1, Type.op_asn);
                            c1 = this.eval(state, null);
                            this.check(c1, Type.sep_cmd);
                            state.op((byte)15, c1);
                            continue block10;
                        }
                        if (c1.type == Type.B_par) {
                            this.func(state, name, false);
                            state.next(Type.sep_cmd);
                            continue block10;
                        }
                        throw state.err(c1);
                    }
                    case K_loc: {
                        int p;
                        while (true) {
                            Comp c1 = state.next(Type.id);
                            Comp c2 = this.code.next();
                            if (((Identifier)c1).com) {
                                throw state.err("invalid identifier", c1);
                            }
                            String name = ((Identifier)c1).id;
                            if (state.varIds.containsKey(name)) {
                                throw state.err("duplicate local variable: " + name, c1);
                            }
                            if (c2.type == Type.op_asn) {
                                c2 = this.eval(state, null);
                                --state.curStack;
                                state.regVar(name);
                            } else {
                                state.regVar(name);
                                p = buffer.position();
                                if (buffer.get(p - 2) == 40) {
                                    buffer.position(p - 1);
                                } else {
                                    state.op((byte)40, null);
                                }
                                buffer.put((byte)(state.lastId - 1));
                            }
                            if (c2.type == Type.sep_cmd) continue block10;
                            this.check(c2, Type.sep_par);
                        }
                    }
                    case K_else: {
                        Comp c1;
                        if (lastElse >= 0 || lastIf < 0) {
                            state.err("else without if", c);
                        }
                        if (this.jump(state, c1 = this.code.next(), lastIf)) {
                            lastIf = -1;
                            continue block10;
                        }
                        state.op((byte)9, c);
                        lastElse = buffer.position();
                        buffer.position(lastElse + 2);
                        buffer.putShort(lastIf, (short)(lastElse + 2));
                        if (c1.type == Type.B_block) {
                            boolean st = this.compBlock(state);
                            buffer.putShort(lastElse, (short)(buffer.position() - (st ? 2 : 0)));
                            lastIf = -1;
                            lastElse = -1;
                            continue block10;
                        }
                        this.check(c1, Type.K_if);
                    }
                    case K_fail: 
                    case K_if: {
                        int p;
                        state.next(Type.B_par);
                        this.check(this.eval(state, null), Type.E_par);
                        Comp c1 = this.code.next();
                        lastIf = buffer.position() + 1;
                        if (this.jump(state, c1, lastIf)) {
                            state.op(c.type == Type.K_fail ? (byte)43 : 10, c1);
                            p = lastIf + 2;
                            buffer.position(p);
                            lastIf = -1;
                        } else {
                            state.op(c.type == Type.K_fail ? (byte)13 : 11, c1);
                            buffer.position(lastIf + 2);
                            this.check(c1, Type.B_block);
                            boolean st = this.compBlock(state);
                            p = buffer.position() - (st ? 2 : 0);
                            buffer.putShort(lastIf, (short)p);
                        }
                        if (lastElse < 0) continue block10;
                        buffer.putShort(lastElse, (short)p);
                        lastElse = -1;
                        continue block10;
                    }
                    case K_for: {
                        ArrayList<Integer> breakPos = state.breakPos;
                        state.breakPos = new ArrayList();
                        ArrayList<Integer> continuePos = state.continuePos;
                        state.continuePos = new ArrayList();
                        state.next(Type.B_par);
                        Identifier c1 = (Identifier)state.next(Type.id);
                        if (c1.com) {
                            throw state.err("invalid identifier", c1);
                        }
                        state.next(Type.op_ind);
                        this.check(this.eval(state, null), Type.E_par);
                        ++state.lastId;
                        state.regVar(c1.id);
                        int p = buffer.position();
                        state.op((byte)41, state.next(Type.B_block));
                        int p1 = buffer.position();
                        buffer.position(p1 + 2);
                        boolean st = this.compBlock(state);
                        int p2 = buffer.position();
                        if (st) {
                            buffer.position(p2 -= 2);
                        }
                        for (int i : state.continuePos) {
                            buffer.putShort(i, (short)p2);
                        }
                        state.op((byte)42, null);
                        buffer.put((byte)(state.lastId - 1));
                        buffer.putShort((short)p);
                        state.varIds.remove(c1.id);
                        state.lastId -= 2;
                        p2 = buffer.position();
                        buffer.putShort(p1, (short)p2);
                        if (!state.breakPos.isEmpty()) {
                            state.op((byte)40, null);
                            buffer.put((byte)(state.lastId - 1));
                            for (int i : state.breakPos) {
                                buffer.putShort(i, (short)p2);
                            }
                        }
                        state.breakPos = breakPos;
                        state.continuePos = continuePos;
                        continue block10;
                    }
                    case K_br: 
                    case K_cont: {
                        state.op((byte)9, c);
                        int p = buffer.position();
                        buffer.position(p + 2);
                        this.jump(state, c, p);
                        continue block10;
                    }
                    case K_ret: {
                        Comp c1 = this.eval(state, Type.sep_cmd);
                        if (c1 != null) {
                            state.hasRet = true;
                            this.check(c1, Type.sep_cmd);
                        } else {
                            c1 = c;
                        }
                        state.op((byte)9, c1);
                        int p = buffer.position();
                        state.returnPos.add(p);
                        buffer.position(p + 2);
                        continue block10;
                    }
                    case B_block: {
                        this.compBlock(state);
                        continue block10;
                    }
                }
                break;
            }
            throw state.err(c);
        }
        if (state.lastId <= variables) {
            return false;
        }
        Iterator<Map.Entry<String, Byte>> it = state.varIds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Byte> e = it.next();
            if (e.getValue() < variables) continue;
            it.remove();
        }
        int p = buffer.position();
        if (buffer.get(p - 2) == 40) {
            buffer.position(p - 1);
        } else {
            state.op((byte)40, null);
        }
        buffer.put((byte)(variables - 1));
        state.lastId = variables;
        return true;
    }

    private boolean jump(State state, Comp c, int p) throws ScriptException {
        switch (c.type) {
            case K_br: {
                if (state.breakPos == null) {
                    throw state.err("break outside loop", c);
                }
                state.breakPos.add(p);
                break;
            }
            case K_cont: {
                if (state.continuePos == null) {
                    throw state.err("continue outside loop", c);
                }
                state.continuePos.add(p);
                break;
            }
            case K_ret: {
                state.returnPos.add(p);
                break;
            }
            default: {
                return false;
            }
        }
        state.next(Type.sep_cmd);
        return true;
    }

    private Comp eval(State state, Type end) throws ScriptException {
        Comp c = this.code.next();
        if (end != null && c.type == end) {
            return null;
        }
        ArrayList<Comp> ops = new ArrayList<Comp>();
        while (true) {
            c = this.evalPre(c, state);
            int p = c.type.prior;
            if (!ops.isEmpty()) {
                this.operators(ops, p, state);
            }
            if (p == 0) {
                return c;
            }
            ops.add(c);
            c = this.code.next();
        }
    }

    private void operators(ArrayList<Comp> ops, int prior, State state) {
        int i = ops.size() - 1;
        Comp c = ops.get(i);
        while (c.type.prior >= prior) {
            switch (c.type) {
                case op_or: {
                    state.op((byte)34, c);
                    break;
                }
                case op_nor: {
                    state.op((byte)36, c);
                    break;
                }
                case op_and: {
                    state.op((byte)33, c);
                    break;
                }
                case op_nand: {
                    state.op((byte)35, c);
                    break;
                }
                case op_xor: {
                    state.op((byte)37, c);
                    break;
                }
                case op_xnor: {
                    state.op((byte)38, c);
                    break;
                }
                case op_not: {
                    state.op((byte)45, c);
                    break;
                }
                case op_eq: {
                    state.op((byte)27, c);
                    break;
                }
                case op_neq: {
                    state.op((byte)28, c);
                    break;
                }
                case op_ls: {
                    state.op((byte)29, c);
                    break;
                }
                case op_nls: {
                    state.op((byte)30, c);
                    break;
                }
                case op_gr: {
                    state.op((byte)31, c);
                    break;
                }
                case op_ngr: {
                    state.op((byte)32, c);
                    break;
                }
                case op_add: {
                    state.op((byte)20, c);
                    break;
                }
                case op_sub: {
                    state.op((byte)21, c);
                    break;
                }
                case op_mul: {
                    state.op((byte)22, c);
                    break;
                }
                case op_div: {
                    state.op((byte)23, c);
                    break;
                }
                case op_mod: {
                    state.op((byte)26, c);
                    break;
                }
                case op_pow: {
                    state.op((byte)44, c);
                    break;
                }
                case op_ind: {
                    state.op((byte)14, c);
                }
            }
            ops.remove(i--);
            if (i < 0) {
                return;
            }
            c = ops.get(i);
        }
    }

    private Comp evalPre(Comp c, State state) throws ScriptException {
        switch (c.type) {
            case op_not: {
                c = this.evalPre(this.code.next(), state);
                state.op((byte)45, null);
                return c;
            }
            case op_sub: {
                c = this.evalPre(this.code.next(), state);
                state.op((byte)24, null);
                return c;
            }
            case op_div: {
                c = this.evalPre(this.code.next(), state);
                state.op((byte)25, null);
                return c;
            }
            case op_num: {
                c = this.evalPre(this.code.next(), state);
                state.op((byte)16, null);
                return c;
            }
            case op_text: {
                ConstValue c1 = (ConstValue)state.next(Type.val);
                if (!(c1.val instanceof Text)) {
                    state.err("exp. string literal", c1);
                }
                c = this.evalPre(this.code.next(), state);
                state.op((byte)39, null);
                Function.putName(buffer, ((Text)c1.val).value, false);
                return c;
            }
            case id: {
                String name = ((Identifier)c).id;
                Comp c1 = this.code.next();
                if (c1.type == Type.B_par) {
                    this.func(state, name, true);
                    return this.code.next();
                }
                Byte p = state.varIds.get(name);
                if (p != null) {
                    state.op((byte)0, c);
                    buffer.put(p);
                } else {
                    state.op((byte)1, c);
                    Function.putName(buffer, name, false);
                }
                return c1;
            }
            case val: {
                IOperand val = ((ConstValue)c).val;
                if (val instanceof Number) {
                    if (val == Number.FALSE) {
                        state.op((byte)7, c);
                    } else if (val == Number.TRUE) {
                        state.op((byte)6, c);
                    } else {
                        state.op((byte)4, c);
                        buffer.putDouble(((Number)val).value);
                    }
                } else if (val instanceof Text) {
                    state.op((byte)5, c);
                    Function.putName(buffer, ((Text)val).value, true);
                } else {
                    state.op((byte)8, c);
                }
                return this.code.next();
            }
            case B_par: {
                Comp c1 = this.eval(state, null);
                this.check(c1, Type.E_par);
                return this.code.next();
            }
            case B_list: {
                int n = this.params(state, Type.E_list);
                state.curStack -= n;
                Comp c1 = this.code.next();
                if (c1.type == Type.op_num) {
                    state.op((byte)18, null);
                    buffer.put((byte)n);
                    return this.code.next();
                }
                if (c1.type == Type.op_text) {
                    state.op((byte)19, null);
                    buffer.put((byte)n);
                    return this.code.next();
                }
                state.op((byte)17, null);
                buffer.put((byte)n);
                return c1;
            }
        }
        throw state.err(c);
    }

    private int params(State state, Type end) throws ScriptException {
        Comp c;
        int n = 0;
        while ((c = this.eval(state, end)) != null) {
            ++n;
            if (c.type == end) break;
            this.check(c, Type.sep_par);
        }
        return n;
    }

    private void func(State state, String name, boolean ret) throws ScriptException {
        int n = this.params(state, Type.E_par);
        state.curStack -= n;
        state.op((byte)12, null);
        Function.putName(buffer, name, false);
        if (ret) {
            if (++state.curStack + state.lastId > state.maxStack) {
                ++state.maxStack;
            }
            n |= 0x80;
        }
        buffer.put((byte)n);
    }

    private void check(Comp c, Type t) throws ScriptException {
        if (c.type != t) {
            throw new ScriptException(String.format("exp. %s , got %s", new Object[]{t, c.type}), this.fileName, c.line, c.col);
        }
    }

    private static int stack(byte op) {
        switch (op) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: {
                return 1;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: {
                return -1;
            }
            case 15: {
                return -3;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        ScriptFiles.createCompiledPackage(new File(args[0]));
    }

    private static enum Type {
        val("literal"),
        id("identifier"),
        op_num("#"),
        op_ind(7, ":"),
        op_text("$"),
        op_asn("="),
        op_or(1, "|"),
        op_nor(1, "~|"),
        op_and(2, "&"),
        op_nand(2, "~&"),
        op_xor(3, "?"),
        op_xnor(3, "~?"),
        op_not("~"),
        op_eq(4, "=="),
        op_neq(4, "~="),
        op_ls(4, "<"),
        op_gr(4, ">"),
        op_nls(4, ">="),
        op_ngr(4, "<="),
        op_add(5, "+"),
        op_sub(5, "-"),
        op_mul(6, "*"),
        op_div(6, "/"),
        op_mod(6, "%"),
        op_pow(7, "^"),
        B_par("("),
        E_par(")"),
        B_list("["),
        E_list("]"),
        B_block("{"),
        E_block("}"),
        sep_par(","),
        sep_cmd(";"),
        K_fail("fail"),
        K_if("if"),
        K_else("else"),
        K_for("for"),
        K_ret("return"),
        K_br("break"),
        K_cont("continue"),
        K_loc("Loc");

        public final int prior;
        private final String text;

        private Type(String text) {
            this(0, text);
        }

        private Type(int prior, String text) {
            this.prior = prior;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class ConstValue
    extends Comp {
        final IOperand val;

        ConstValue(IOperand val) {
            super(Type.val);
            this.val = val;
        }
    }

    private static class Identifier
    extends Comp {
        boolean com;
        String id;

        Identifier(String s, boolean com) {
            super(Type.id);
            this.com = com;
            this.id = s;
        }
    }

    private static class Comp {
        Type type;
        short line;
        short col;

        Comp(Type t) {
            this.type = t;
        }
    }

    private class State {
        HashMap<String, Byte> varIds = new HashMap();
        HashMap<Short, Short> lines = new HashMap();
        ArrayList<Integer> breakPos;
        ArrayList<Integer> continuePos;
        ArrayList<Integer> returnPos = new ArrayList();
        int lastId = 0;
        int maxStack = 0;
        int lineOfs;
        int curStack = 0;
        boolean hasRet = false;
        final String name;

        State(String name) {
            this.name = name;
        }

        Comp next(Type t) throws ScriptException {
            Comp c = (Comp)Compiler.this.code.next();
            if (c.type != t) {
                throw new ScriptException(String.format("exp. %s , got %s", new Object[]{t, c.type}), this.name, c.line, c.col);
            }
            return c;
        }

        void op(byte op, Comp c) {
            int i;
            buffer.put(op);
            if (c != null) {
                this.lines.putIfAbsent((short)(c.line - this.lineOfs), (short)buffer.position());
            }
            if ((i = this.lastId + (this.curStack += Compiler.stack(op))) > this.maxStack) {
                this.maxStack = i;
            }
        }

        int regVar(String name) {
            this.varIds.put(name, (byte)this.lastId++);
            if (this.lastId > this.maxStack) {
                this.maxStack = this.lastId;
            }
            return this.lastId - 1;
        }

        ScriptException err(String msg, Comp c) {
            return new ScriptException(msg, this.name, c.line, c.col);
        }

        ScriptException err(Comp c) {
            return new ScriptException(String.format("unexpected token: %s", new Object[]{c.type}), this.name, c.line, c.col);
        }
    }

    private static class LineTracker {
        final ArrayList<Comp> parsed = new ArrayList();
        final Reader reader;
        short line = 1;
        short col = 0;

        LineTracker(Reader reader) {
            this.reader = reader;
        }

        int next() throws IOException {
            int c = this.reader.read();
            if (c == 10) {
                this.line = (short)(this.line + 1);
                this.col = 0;
            } else {
                this.col = c == 9 ? (short)(this.col + 4) : (short)(this.col + 1);
            }
            return c;
        }

        void add(Comp c) {
            c.line = this.line;
            c.col = this.col;
            this.parsed.add(c);
        }

        Comp prev(int p) {
            return this.parsed.get(this.parsed.size() + p);
        }

        void remPrev() {
            this.parsed.remove(this.parsed.size() - 1);
        }
    }
}

