/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptFiles;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.util.TooltipEditor;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TooltipUtil {
    public static String CURRENT_DOMAIN = "";
    private static String ShiftHint;
    private static String AltHint;
    private static String FluidDispUnit;
    private static String EnergyDispUnit;
    private static String PowerDispUnit;
    private static String LinkPosFormat;
    private static String LinkPosFormat1;
    public static String[] sides;
    private static final HashMap<String, String> variables;
    private static final Pattern varInsertion;
    private static final Pattern variantReplacement;
    private static final Pattern numberFormat;
    private static String lastKey;
    private static String lastValue;
    public static TooltipEditor editor;
    public static boolean shiftOverride;
    public static boolean altOverride;
    public static boolean overrideModifiers;
    private static final String[] DecScale;
    public static final double[] ScaleUnits;
    public static final double[] exp10;

    public static String unlocalizedNameFor(IForgeRegistryEntry.Impl<?> obj) {
        ResourceLocation loc = obj.getRegistryName();
        return (loc.func_110624_b().equals(CURRENT_DOMAIN) ? CURRENT_DOMAIN : "cd4017be") + '.' + loc.func_110623_a();
    }

    public static String getShiftHint() {
        if (ShiftHint == null && (ShiftHint = I18n.func_74838_a((String)"cd4017be.shiftHint")) == "cd4017be.shiftHint") {
            ShiftHint = "<SHIFT for info>";
        }
        return ShiftHint;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean showShiftHint() {
        return overrideModifiers ? shiftOverride : GuiScreen.func_146272_n();
    }

    public static String getAltHint() {
        if (AltHint == null && (AltHint = I18n.func_74838_a((String)"cd4017be.altHint")) == "cd4017be.altHint") {
            AltHint = "<ALT for extra>";
        }
        return AltHint;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean showAltHint() {
        return overrideModifiers ? altOverride : GuiScreen.func_175283_s();
    }

    public static String getFluidUnit() {
        if (FluidDispUnit == null && (FluidDispUnit = I18n.func_74838_a((String)"cd4017be.fluidUnit")) == "cd4017be.fluidUnit") {
            FluidDispUnit = "B";
        }
        return FluidDispUnit;
    }

    public static String getEnergyUnit() {
        if (EnergyDispUnit == null && (EnergyDispUnit = I18n.func_74838_a((String)"cd4017be.energyUnit")) == "cd4017be.energyUnit") {
            EnergyDispUnit = "kJ";
        }
        return EnergyDispUnit;
    }

    public static String getPowerUnit() {
        if (PowerDispUnit == null && (PowerDispUnit = I18n.func_74838_a((String)"cd4017be.powerUnit")) == "cd4017be.powerUnit") {
            PowerDispUnit = "kW";
        }
        return PowerDispUnit;
    }

    public static String formatLink(BlockPos pos, EnumFacing side) {
        if (LinkPosFormat == null && (LinkPosFormat = I18n.func_74838_a((String)"cd4017be.linkPos")) == "cd4017be.linkPos") {
            LinkPosFormat = "Link: x=%d y=%d z=%d %s";
        }
        return String.format(LinkPosFormat, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side != null ? sides[side.ordinal()] : "");
    }

    public static String formatLink(BlockPos pos, EnumFacing side, int dim) {
        if (LinkPosFormat1 == null && (LinkPosFormat1 = I18n.func_74838_a((String)"cd4017be.linkPos1")) == "cd4017be.linkPos1") {
            LinkPosFormat1 = "Link: x=%d y=%d z=%d %s @dim %d";
        }
        return String.format(LinkPosFormat1, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side != null ? sides[side.ordinal()] : "", dim);
    }

    public static void addScriptVariables() {
        RecipeScriptContext cont = RecipeScriptContext.instance;
        for (ScriptFiles.Version v : RecipeScriptContext.scriptRegistry) {
            Script m = (Script)cont.modules.get(v.name);
            if (m == null) continue;
            for (Map.Entry<String, IOperand> var : m.variables.entrySet()) {
                TooltipUtil.addVar(var.getKey(), var.getValue().value());
            }
        }
    }

    private static void addVar(String name, Object o) {
        if (o instanceof Double) {
            variables.put(name, TooltipUtil.formatNumber((Double)o, 4, 0));
        } else if (o instanceof double[]) {
            double[] arr = (double[])o;
            for (int i = 0; i < arr.length; ++i) {
                variables.put(name + ":" + i, TooltipUtil.formatNumber(arr[i], 4, 0));
            }
        } else if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            for (int i = 0; i < arr.length; ++i) {
                TooltipUtil.addVar(name + ":" + i, arr[i]);
            }
        } else if (o instanceof ItemStack) {
            ItemStack item = (ItemStack)o;
            variables.put(name, (item.func_190916_E() > 1 ? item.func_190916_E() + "x " : "") + item.func_82833_r());
        } else if (o != null) {
            variables.put(name, o.toString());
        }
    }

    public static String getConfigFormat(String s) {
        Matcher m;
        String t;
        if (s.equals(lastKey) && editor == null) {
            return lastValue;
        }
        lastKey = s;
        String string = t = editor != null ? editor.getTranslation(s) : I18n.func_74838_a((String)s);
        if (t.equals(s)) {
            m = variantReplacement.matcher(s);
            if (!m.find()) {
                lastValue = s;
                return lastValue;
            }
            String n = m.group(1);
            String s1 = s.substring(0, m.start(1)) + "i" + s.substring(m.end(1));
            String string2 = t = editor != null ? editor.getTranslation(s1) : I18n.func_74838_a((String)s1);
            if (t.equals(s1)) {
                lastValue = s;
                return lastValue;
            }
            t = t.replace("\\i", n);
        }
        s = t.trim().replace("\\n", "\n");
        m = varInsertion.matcher(s);
        String s1 = "";
        while (m.find()) {
            String var = variables.get(m.group(1));
            if (var == null) continue;
            s1 = s1 + s.substring(0, m.start()) + var;
            s = s.substring(m.end());
            m.reset(s);
        }
        lastValue = s1 + s;
        return lastValue;
    }

    public static String format(String s, Object ... args) {
        s = TooltipUtil.translate(s).trim().replace("\\n", "\n");
        try {
            Matcher m = numberFormat.matcher(s);
            String s1 = "";
            while (m.find()) {
                double val = 0.0;
                int exp = 0;
                int n = 3;
                String g = m.group(1);
                if (g != null) {
                    val = ((Number)args[Integer.parseInt(g)]).doubleValue();
                } else {
                    for (int i = 0; i < args.length; ++i) {
                        if (!(args[i] instanceof Number)) continue;
                        val = ((Number)args[i]).doubleValue();
                        Object[] nargs = new Object[args.length - 1];
                        if (i > 0) {
                            System.arraycopy(args, 0, nargs, 0, i);
                        }
                        if (i < nargs.length) {
                            System.arraycopy(args, i + 1, nargs, i, nargs.length - i);
                        }
                        args = nargs;
                        break;
                    }
                }
                g = m.group(2);
                if (g != null && !g.isEmpty()) {
                    exp = Integer.parseInt(g);
                }
                if ((g = m.group(3)) != null) {
                    n = Integer.parseInt(g);
                }
                s1 = s1 + s.substring(0, m.start()) + TooltipUtil.formatNumber(val, n, exp);
                s = s.substring(m.end());
                m.reset(s);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Boolean) {
                    args[i] = TooltipUtil.translate((Boolean)args[i] != false ? "gui.yes" : "gui.no");
                    continue;
                }
                if (!(args[i] instanceof EnumFacing)) continue;
                args[i] = TooltipUtil.translate("enumfacing." + args[i]);
            }
            return String.format(s1 + s, args);
        }
        catch (IllegalFormatException e) {
            return s + "\n" + e.toString();
        }
    }

    public static String translate(String s) {
        return s.startsWith("\\") ? s.substring(1) : (editor != null ? editor.getTranslation(s) : I18n.func_74838_a((String)s));
    }

    public static boolean hasTranslation(String s) {
        return I18n.func_94522_b((String)s) || editor != null && editor.hasEdited(s);
    }

    public static String formatNumber(double x, int w, int c) {
        return TooltipUtil.formatNumber(x, w, c < 0 ? 1.0 / exp10[-c] : exp10[c], false, true);
    }

    public static String formatNumber(double x, int w, double c, boolean sign, boolean trim) {
        if (w < 0 || w >= exp10.length) {
            throw new IllegalArgumentException("invalid width " + w);
        }
        if (Double.isNaN(x)) {
            return "NaN";
        }
        StringBuilder sb = new StringBuilder(w + 3);
        if (x < 0.0) {
            sb.append('-');
            x = -x;
        } else if (sign) {
            sb.append('+');
        }
        int i = Arrays.binarySearch(ScaleUnits, x / c);
        if (i < 0) {
            i = -2 - i;
        }
        if (i < 0) {
            return sb.append('0').toString();
        }
        if (i >= DecScale.length) {
            return sb.append("Infinity").toString();
        }
        int y = (int)Math.floor(x /= ScaleUnits[i]);
        w += sb.length();
        int p = sb.append(y).length();
        x -= (double)y;
        if ((w -= p) > 0) {
            y = (int)Math.round(x *= exp10[w]);
            while (w > 0) {
                int z;
                if ((y -= (z = y / 10) * 10) != 0 || !trim) {
                    sb.insert(p, (char)(48 + y));
                    trim = false;
                }
                y = z;
                --w;
            }
        }
        if (!trim) {
            sb.insert(p, '.');
        }
        return sb.append(DecScale[i]).toString();
    }

    public static String formatNumber(double x, int w) {
        String ds;
        String tex = String.format("%." + w + "f", x);
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex;
    }

    static {
        sides = new String[]{"B", "T", "N", "S", "W", "E"};
        variables = new HashMap();
        varInsertion = Pattern.compile("\\\\<([\\w:]+)>");
        variantReplacement = Pattern.compile("\\:(\\d+)");
        numberFormat = Pattern.compile("%(?:(\\d+)\\$)?(?:(-?\\d?)\\.(\\d+))?u");
        shiftOverride = true;
        altOverride = false;
        overrideModifiers = FMLCommonHandler.instance().getSide() == Side.SERVER;
        DecScale = new String[]{"a", "f", "p", "n", "u", "m", "", "k", "M", "G", "T", "P", "E"};
        ScaleUnits = new double[]{1.0E-18, 1.0E-15, 1.0E-12, 1.0E-9, 1.0E-6, 0.001, 1.0, 1000.0, 1000000.0, 1.0E9, 1.0E12, 1.0E15, 1.0E18, 1.0E21};
        exp10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15};
    }
}

