/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.dave.compactmachines3.gui.framework.GUI;
import org.dave.compactmachines3.gui.framework.event.FocusChangedEvent;
import org.dave.compactmachines3.gui.framework.event.IEvent;
import org.dave.compactmachines3.gui.framework.event.IWidgetListener;
import org.dave.compactmachines3.gui.framework.event.MouseClickEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;

public class Widget {
    public int x;
    public int y;
    public int width;
    public int height;
    public String id;
    boolean enabled = true;
    boolean focused = false;
    boolean visible = true;
    Widget parent;
    List<String> tooltipLines = new ArrayList<String>();
    Map<Class<? extends IEvent>, List<IWidgetListener>> eventListeners = new HashMap<Class<? extends IEvent>, List<IWidgetListener>>();
    List<IWidgetListener> anyEventListener = new ArrayList<IWidgetListener>();

    public Widget() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            widget.getRootWidget().fireEvent(new FocusChangedEvent());
            if (widget.focusable()) {
                widget.focused = true;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(FocusChangedEvent.class, (event, widget) -> {
            widget.focused = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public boolean hasToolTip() {
        return this.tooltipLines != null && this.tooltipLines.size() > 0;
    }

    public List<String> getTooltip() {
        if (this.tooltipLines == null) {
            return Collections.emptyList();
        }
        return this.tooltipLines;
    }

    public Widget setTooltipLines(List<String> tooltipLines) {
        this.tooltipLines = tooltipLines;
        return this;
    }

    public Widget setTooltipLines(String ... tooltipLines) {
        this.tooltipLines = new ArrayList<String>();
        for (String line : tooltipLines) {
            this.tooltipLines.add(line);
        }
        return this;
    }

    public Widget addTooltipLine(String ... tooltipLines) {
        for (String line : tooltipLines) {
            this.tooltipLines.add(line);
        }
        return this;
    }

    public Widget addTooltipLine(List<String> strings) {
        this.tooltipLines.addAll(strings);
        return this;
    }

    public boolean focusable() {
        return true;
    }

    public static int computeGuiScale(Minecraft mc) {
        int scaleFactor = 1;
        int k = mc.field_71474_y.field_74335_Z;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        return this.getClass().getSimpleName() + "[?]";
    }

    public boolean isPosInside(int x, int y) {
        boolean isInsideX = this.getActualX() <= x && x < this.getActualX() + this.width;
        boolean isInsideY = this.getActualY() <= y && y < this.getActualY() + this.height;
        return isInsideX && isInsideY;
    }

    public int getActualX() {
        int result = this.x;
        Widget parent = this.parent;
        while (parent != null) {
            result += parent.x;
            parent = parent.parent;
        }
        return result;
    }

    public int getActualY() {
        int result = this.y;
        Widget parent = this.parent;
        while (parent != null) {
            result += parent.y;
            parent = parent.parent;
        }
        return result;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisabled() {
        this.enabled = false;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public Widget getRootWidget() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootWidget();
    }

    public GUI getGUI() {
        Widget root = this.getRootWidget();
        if (root instanceof GUI) {
            return (GUI)root;
        }
        return null;
    }

    public void shiftAndDraw(GuiScreen screen) {
        this.drawBeforeShift(screen);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
        this.draw(screen);
        GlStateManager.func_179121_F();
    }

    public void drawBeforeShift(GuiScreen screen) {
    }

    public void draw(GuiScreen screen) {
    }

    public <T extends IEvent> void addListener(Class<T> eventClass, IWidgetListener<? super T> listener) {
        if (!this.eventListeners.containsKey(eventClass)) {
            this.eventListeners.put(eventClass, new ArrayList());
        }
        this.eventListeners.get(eventClass).add(listener);
    }

    public void addAnyListener(IWidgetListener listener) {
        this.anyEventListener.add(listener);
    }

    public <T extends IEvent> void addChildListener(Class<T> eventClass, Widget receiveEventsFromWidget) {
        Widget self = this;
        receiveEventsFromWidget.addListener(eventClass, (event, widget) -> self.fireEvent(event));
    }

    public WidgetEventResult fireEvent(IEvent event) {
        WidgetEventResult immediateResult;
        for (IWidgetListener listener : this.anyEventListener) {
            immediateResult = listener.call(event, this);
            if (immediateResult != WidgetEventResult.HANDLED) continue;
            return WidgetEventResult.HANDLED;
        }
        if (!this.eventListeners.containsKey(event.getClass())) {
            return WidgetEventResult.CONTINUE_PROCESSING;
        }
        for (IWidgetListener listener : this.eventListeners.get(event.getClass())) {
            immediateResult = listener.call(event, this);
            if (immediateResult != WidgetEventResult.HANDLED) continue;
            return WidgetEventResult.HANDLED;
        }
        return WidgetEventResult.CONTINUE_PROCESSING;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

