/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModCreativeTabs;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.tools.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockFluidPipe
extends Block {
    public static final IProperty<Boolean> DOWN = PropertyBool.func_177716_a((String)"down");
    public static final IProperty<Boolean> UP = PropertyBool.func_177716_a((String)"up");
    public static final IProperty<Boolean> NORTH = PropertyBool.func_177716_a((String)"north");
    public static final IProperty<Boolean> SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final IProperty<Boolean> WEST = PropertyBool.func_177716_a((String)"west");
    public static final IProperty<Boolean> EAST = PropertyBool.func_177716_a((String)"east");

    public BlockFluidPipe() {
        super(new Material(MapColor.field_151660_b));
        this.setRegistryName("fluid_pipe");
        this.func_149663_c("fluid_pipe");
        this.func_149647_a(ModCreativeTabs.TAB_CAR);
        this.func_149711_c(0.25f);
        this.field_149783_u = true;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(UP, (Comparable)Boolean.valueOf(false)).func_177226_a(DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a(NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a(SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a(EAST, (Comparable)Boolean.valueOf(false)).func_177226_a(WEST, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float x1 = 0.375f;
        float y1 = 0.375f;
        float z1 = 0.375f;
        float x2 = 0.625f;
        float y2 = 0.625f;
        float z2 = 0.625f;
        if (BlockFluidPipe.isConnectedTo(source, pos, EnumFacing.UP)) {
            y2 = 1.0f;
        }
        if (BlockFluidPipe.isConnectedTo(source, pos, EnumFacing.DOWN)) {
            y1 = 0.0f;
        }
        if (BlockFluidPipe.isConnectedTo(source, pos, EnumFacing.SOUTH)) {
            z2 = 1.0f;
        }
        if (BlockFluidPipe.isConnectedTo(source, pos, EnumFacing.NORTH)) {
            z1 = 0.0f;
        }
        if (BlockFluidPipe.isConnectedTo(source, pos, EnumFacing.EAST)) {
            x2 = 1.0f;
        }
        if (BlockFluidPipe.isConnectedTo(source, pos, EnumFacing.WEST)) {
            x1 = 0.0f;
        }
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static boolean isConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
        if (state.func_177230_c().equals((Object)ModBlocks.FLUID_PIPE) || state.func_177230_c().equals((Object)ModBlocks.FLUID_EXTRACTOR)) {
            return true;
        }
        return FluidUtils.isFluidHandler(world, pos, facing);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, EAST, WEST, NORTH, SOUTH});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.func_176223_P();
        if (BlockFluidPipe.isConnectedTo(world, pos, EnumFacing.UP)) {
            actualState = actualState.func_177226_a(UP, (Comparable)Boolean.valueOf(true));
        }
        if (BlockFluidPipe.isConnectedTo(world, pos, EnumFacing.DOWN)) {
            actualState = actualState.func_177226_a(DOWN, (Comparable)Boolean.valueOf(true));
        }
        if (BlockFluidPipe.isConnectedTo(world, pos, EnumFacing.SOUTH)) {
            actualState = actualState.func_177226_a(SOUTH, (Comparable)Boolean.valueOf(true));
        }
        if (BlockFluidPipe.isConnectedTo(world, pos, EnumFacing.NORTH)) {
            actualState = actualState.func_177226_a(NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (BlockFluidPipe.isConnectedTo(world, pos, EnumFacing.EAST)) {
            actualState = actualState.func_177226_a(EAST, (Comparable)Boolean.valueOf(true));
        }
        if (BlockFluidPipe.isConnectedTo(world, pos, EnumFacing.WEST)) {
            actualState = actualState.func_177226_a(WEST, (Comparable)Boolean.valueOf(true));
        }
        return actualState;
    }
}

