/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.ItemTools;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class TileEntityEnergyFluidProducer
extends TileEntityBase
implements IEnergyStorage,
ISidedInventory,
ITickable,
IFluidHandler {
    protected InventoryBasic inventory = new InventoryBasic(this.func_145748_c_().func_150254_d(), false, 2);
    protected int maxStorage = 10000;
    protected int storedEnergy = 0;
    protected int energyUsage = 10;
    protected int timeToGenerate = 0;
    protected int generatingTime = 200;
    protected int maxMillibuckets = 3000;
    protected int millibucketsPerUse = 100;
    protected int currentMillibuckets = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isEnabled()) {
            this.setBlockEnabled(true);
        } else {
            this.setBlockEnabled(false);
        }
        ItemStack input = this.inventory.func_70301_a(0);
        ItemStack output = this.inventory.func_70301_a(1);
        if (this.timeToGenerate > 0 && this.storedEnergy >= this.energyUsage) {
            this.storedEnergy -= this.energyUsage;
            --this.timeToGenerate;
            if (this.timeToGenerate == 0) {
                if (ItemTools.isStackEmpty(output)) {
                    this.inventory.func_70299_a(1, this.getOutputItem());
                } else if (output.func_190916_E() < output.func_77976_d() && ItemStack.func_179545_c((ItemStack)output, (ItemStack)this.getOutputItem())) {
                    ItemTools.incrItemStack(output, null);
                    this.inventory.func_70299_a(1, output);
                }
                if (this.currentMillibuckets + this.millibucketsPerUse <= this.maxMillibuckets) {
                    this.currentMillibuckets += this.millibucketsPerUse;
                }
            }
        } else if (this.storedEnergy >= this.energyUsage && !ItemTools.isStackEmpty(input) && this.isValidItem(input) && (ItemTools.isStackEmpty(output) || output.func_190916_E() < output.func_77976_d()) && this.currentMillibuckets + this.millibucketsPerUse <= this.maxMillibuckets) {
            ItemTools.decrItemStack(input, null);
            if (input.func_190916_E() <= 0) {
                ItemTools.removeStackFromSlot((IInventory)this.inventory, 0);
            }
            this.timeToGenerate = this.generatingTime;
        }
        this.func_70296_d();
    }

    public boolean isEnabled() {
        return this.storedEnergy >= this.energyUsage && this.currentMillibuckets + this.millibucketsPerUse <= this.maxMillibuckets && (!ItemTools.isStackEmpty(this.inventory.func_70301_a(0)) || this.timeToGenerate > 0 && this.storedEnergy > 0) && (ItemTools.isStackEmpty(this.inventory.func_70301_a(1)) || this.inventory.func_70301_a(1).func_190916_E() < this.inventory.func_70301_a(1).func_77976_d());
    }

    public abstract BlockGui getOwnBlock();

    public void setBlockEnabled(boolean enabled) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c().equals((Object)this.getOwnBlock())) {
            this.getOwnBlock().setPowered(this.field_145850_b, this.field_174879_c, state, enabled);
        }
    }

    public abstract ItemStack getOutputItem();

    public abstract boolean isValidItem(ItemStack var1);

    public float getEnergyPercent() {
        return (float)this.storedEnergy / (float)this.maxStorage;
    }

    public float getFluidPercent() {
        return (float)this.currentMillibuckets / (float)this.maxMillibuckets;
    }

    public float getProgress() {
        return (float)this.timeToGenerate / (float)this.generatingTime;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.timeToGenerate;
            }
            case 1: {
                return this.storedEnergy;
            }
            case 2: {
                return this.currentMillibuckets;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.timeToGenerate = value;
                break;
            }
            case 1: {
                this.storedEnergy = value;
                break;
            }
            case 2: {
                this.currentMillibuckets = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("energy_stored", this.storedEnergy);
        compound.func_74768_a("time_generated", this.timeToGenerate);
        compound.func_74768_a("fluid_stored", this.currentMillibuckets);
        ItemTools.saveInventory(compound, "slots", (IInventory)this.inventory);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.storedEnergy = compound.func_74762_e("energy_stored");
        this.timeToGenerate = compound.func_74762_e("time_generated");
        this.currentMillibuckets = compound.func_74762_e("fluid_stored");
        ItemTools.readInventory(compound, "slots", (IInventory)this.inventory);
        super.func_145839_a(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public abstract ITextComponent func_145748_c_();

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public InventoryBasic getInventory() {
        return this.inventory;
    }

    public int getMaxStorage() {
        return this.maxStorage;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getEnergyUsage() {
        return this.energyUsage;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    public int getGeneratingTime() {
        return this.generatingTime;
    }

    public int getMaxMillibuckets() {
        return this.maxMillibuckets;
    }

    public int getMillibucketsPerUse() {
        return this.millibucketsPerUse;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    public abstract Fluid getProducingFluid();

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack(TileEntityEnergyFluidProducer.this.getProducingFluid(), TileEntityEnergyFluidProducer.this.currentMillibuckets);
            }

            public int getCapacity() {
                return TileEntityEnergyFluidProducer.this.maxMillibuckets;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals(TileEntityEnergyFluidProducer.this.getProducingFluid());
            }

            public boolean canDrain() {
                return true;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int amount = Math.min(resource.amount, this.currentMillibuckets);
        if (doDrain) {
            this.currentMillibuckets -= amount;
            this.func_70296_d();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = Math.min(maxDrain, this.currentMillibuckets);
        if (doDrain) {
            this.currentMillibuckets -= amount;
            this.func_70296_d();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxStorage - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.func_70296_d();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

