/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererTank
extends TileEntitySpecialRenderer<TileEntityTank> {
    public static final ResourceLocation LOCATION_TANK = new ResourceLocation("car", "textures/blocks/tank_line.png");

    public void render(TileEntityTank te, double x, double y, double z, float f, int i, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        double amount = te.getFillPercent();
        FluidStack stack = te.getFluid();
        if (amount > 0.0 && stack != null) {
            this.func_147499_a(TextureMap.field_110575_b);
            TileEntitySpecialRendererTank.renderFluid(te, stack.getFluid(), amount, 0.0);
        }
        this.func_147499_a(LOCATION_TANK);
        TileEntitySpecialRendererTank.renderLines(te);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
    }

    public static void renderFluid(TileEntityTank tank, Fluid fluid, double amount, double yStart) {
        GlStateManager.func_179094_E();
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
        double uMin = texture.func_94209_e();
        double uMax = texture.func_94212_f();
        double vMin = texture.func_94206_g();
        double vMax = texture.func_94210_h();
        double vHeight = vMax - vMin;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float s = 0.0f;
        if (!tank.isFluidConnected(EnumFacing.NORTH)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 0.0 + (double)s).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181675_d();
        }
        if (!tank.isFluidConnected(EnumFacing.SOUTH)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 1.0 - (double)s).func_187315_a(uMax, vMin).func_181675_d();
        }
        if (!tank.isFluidConnected(EnumFacing.EAST)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 0.0 + (double)s).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart, 1.0 - (double)s).func_187315_a(uMax, vMin).func_181675_d();
        }
        if (!tank.isFluidConnected(EnumFacing.WEST)) {
            buffer.func_181662_b(0.0 + (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181675_d();
        }
        if (!tank.isFluidConnected(EnumFacing.DOWN)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMax).func_181675_d();
        }
        if (!tank.isFluidConnected(EnumFacing.UP)) {
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMax).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderLines(TileEntityTank te) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (te.isTankConnectedTo(facing)) continue;
            for (EnumDirection direction : EnumDirection.values()) {
                if (te.isTankConnectedTo(direction.to(facing))) continue;
                TileEntitySpecialRendererTank.drawLine(facing, direction);
            }
        }
    }

    public static void drawLine(EnumFacing side, EnumDirection line) {
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TileEntitySpecialRendererTank.rotate(side);
        GlStateManager.func_179139_a((double)1.01, (double)1.01, (double)1.01);
        GlStateManager.func_179137_b((double)-0.005, (double)-0.005, (double)-0.005);
        TileEntitySpecialRendererTank.drawSide(line, side, buffer);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void rotate(EnumFacing facing) {
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
    }

    public static void drawSide(EnumDirection line, EnumFacing side, BufferBuilder buffer) {
        switch (line) {
            case UP: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                break;
            }
            case DOWN: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                break;
            }
            case RIGHT: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                break;
            }
            case LEFT: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                break;
            }
        }
    }

    public static enum EnumDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public EnumFacing to(EnumFacing facing) {
            switch (facing) {
                case NORTH: {
                    switch (this) {
                        case UP: {
                            return EnumFacing.UP;
                        }
                        case DOWN: {
                            return EnumFacing.DOWN;
                        }
                        case LEFT: {
                            return EnumFacing.EAST;
                        }
                        case RIGHT: {
                            return EnumFacing.WEST;
                        }
                    }
                }
                case SOUTH: {
                    switch (this) {
                        case UP: {
                            return EnumFacing.UP;
                        }
                        case DOWN: {
                            return EnumFacing.DOWN;
                        }
                        case LEFT: {
                            return EnumFacing.WEST;
                        }
                        case RIGHT: {
                            return EnumFacing.EAST;
                        }
                    }
                }
                case EAST: {
                    switch (this) {
                        case UP: {
                            return EnumFacing.UP;
                        }
                        case DOWN: {
                            return EnumFacing.DOWN;
                        }
                        case LEFT: {
                            return EnumFacing.SOUTH;
                        }
                        case RIGHT: {
                            return EnumFacing.NORTH;
                        }
                    }
                }
                case WEST: {
                    switch (this) {
                        case UP: {
                            return EnumFacing.UP;
                        }
                        case DOWN: {
                            return EnumFacing.DOWN;
                        }
                        case LEFT: {
                            return EnumFacing.NORTH;
                        }
                        case RIGHT: {
                            return EnumFacing.SOUTH;
                        }
                    }
                }
                case UP: {
                    switch (this) {
                        case UP: {
                            return EnumFacing.NORTH;
                        }
                        case DOWN: {
                            return EnumFacing.SOUTH;
                        }
                        case LEFT: {
                            return EnumFacing.WEST;
                        }
                        case RIGHT: {
                            return EnumFacing.EAST;
                        }
                    }
                }
                case DOWN: {
                    switch (this) {
                        case UP: {
                            return EnumFacing.SOUTH;
                        }
                        case DOWN: {
                            return EnumFacing.NORTH;
                        }
                        case LEFT: {
                            return EnumFacing.WEST;
                        }
                        case RIGHT: {
                            return EnumFacing.EAST;
                        }
                    }
                }
            }
            return EnumFacing.UP;
        }
    }
}

