/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityCarTemperatureBase;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopStarting;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityCarBatteryBase
extends EntityCarTemperatureBase {
    private static final DataParameter<Integer> BATTERY_LEVEL = EntityDataManager.func_187226_a(EntityCarBatteryBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STARTING_TIME = EntityDataManager.func_187226_a(EntityCarBatteryBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> STARTING = EntityDataManager.func_187226_a(EntityCarBatteryBase.class, (DataSerializer)DataSerializers.field_187198_h);
    @SideOnly(value=Side.CLIENT)
    private SoundLoopStarting startingLoop;
    private boolean carStopped;
    private boolean carStarted;
    private int timeSinceStarted;

    public EntityCarBatteryBase(World worldIn) {
        super(worldIn);
    }

    @Override
    public void func_70071_h_() {
        int time;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isStarted()) {
                ++this.timeSinceStarted;
                if (this.field_70173_aa % 2 == 0) {
                    this.spawnParticles(this.getSpeed() > 0.1f);
                }
            } else {
                this.timeSinceStarted = 0;
            }
            return;
        }
        if (this.isStarting()) {
            if (this.field_70173_aa % 2 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() - this.getBatteryUsage());
            }
            this.setStartingTime(this.getStartingTime() + 1);
            if (this.getBatteryLevel() <= 0) {
                this.setStarting(false, true);
            }
        } else {
            this.setStartingTime(0);
        }
        if ((time = this.getStartingTime()) > 0 && time > this.getTimeToStart()) {
            this.startCarEngine();
        }
        if (this.isStarted()) {
            this.setStartingTime(0);
            this.carStarted = true;
            float speedPerc = this.getSpeed() / this.getMaxSpeed();
            int chargingRate = (int)(speedPerc * 7.0f);
            if (chargingRate < 5) {
                chargingRate = 1;
            }
            int tempRate = (int)(speedPerc * 10.0f);
            if (this.field_70173_aa % 20 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() + chargingRate);
            }
        }
    }

    public void spawnParticles(boolean driving) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        Vec3d lookVec = this.func_70040_Z().func_72432_b();
        double offX = lookVec.field_72450_a * (double)(-this.field_70130_N) / 2.0;
        double offY = lookVec.field_72448_b;
        double offZ = lookVec.field_72449_c * (double)(-this.field_70130_N) / 2.0;
        if (this.timeSinceStarted > 0 && this.timeSinceStarted < 20 && this.getTemperature() < 50.0f) {
            double speedX = lookVec.field_72450_a * -0.1;
            double speedZ = lookVec.field_72449_c * -0.1;
            if (this instanceof EntityCarDamageBase) {
                float damage = ((EntityCarDamageBase)this).getDamage();
                int count = 1;
                double r = 0.1;
                if (damage > 0.9f) {
                    count = 6;
                    r = 0.7;
                } else if (damage > 0.75f) {
                    count = 3;
                    r = 0.7;
                } else if (damage > 0.5f) {
                    count = 2;
                    r = 0.3;
                }
                for (int i = 0; i <= count; ++i) {
                    this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, offX, offY, offZ, speedX, speedZ, r);
                }
            } else {
                this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, offX, offY, offZ, speedX, speedZ);
            }
        } else if (driving) {
            double speedX = lookVec.field_72450_a * -0.2;
            double speedZ = lookVec.field_72449_c * -0.2;
            this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, offX, offY, offZ, speedX, speedZ);
        } else {
            double speedX = lookVec.field_72450_a * -0.05;
            double speedZ = lookVec.field_72449_c * -0.05;
            this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, offX, offY, offZ, speedX, speedZ);
        }
    }

    private void spawnParticle(EnumParticleTypes particleTypes, double offX, double offY, double offZ, double speedX, double speedZ, double random) {
        this.field_70170_p.func_175688_a(particleTypes, this.field_70165_t + offX + this.field_70146_Z.nextDouble() * random, this.field_70163_u + this.field_70146_Z.nextDouble() * random + (double)(this.field_70131_O / 8.0f), this.field_70161_v + offZ + this.field_70146_Z.nextDouble() * random, speedX, 0.0, speedZ, new int[0]);
    }

    private void spawnParticle(EnumParticleTypes particleTypes, double offX, double offY, double offZ, double speedX, double speedZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, speedX, speedZ, 0.1);
    }

    public int getTimeToStart() {
        int baseTime = this.field_70146_Z.nextInt(20) + 10;
        float temp = this.getTemperature();
        if (temp < 0.0f) {
            baseTime += 30;
        } else if (temp < 10.0f) {
            baseTime += 25;
        } else if (temp < 30.0f) {
            baseTime += 20;
        } else if (temp < 60.0f) {
            baseTime += 15;
        }
        float batteryPerc = this.getBatteryPercentage();
        if ((double)batteryPerc < 0.5) {
            baseTime += 25;
        } else if ((double)batteryPerc < 0.75) {
            baseTime += 15;
        }
        return baseTime;
    }

    public int getBatteryUsage() {
        if (!Config.useBattery) {
            return 0;
        }
        float temp = this.getBiomeTemperatureCelsius();
        int baseUsage = 2;
        if (temp < 0.0f) {
            baseUsage += 2;
        } else if (temp < 15.0f) {
            ++baseUsage;
        }
        return baseUsage;
    }

    @Override
    public void setStarted(boolean started) {
        this.setStarting(false, false);
        super.setStarted(started);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BATTERY_LEVEL, (Object)this.getMaxBatteryLevel());
        this.field_70180_af.func_187214_a(STARTING_TIME, (Object)0);
        this.field_70180_af.func_187214_a(STARTING, (Object)false);
    }

    public int getStartingTime() {
        return (Integer)this.field_70180_af.func_187225_a(STARTING_TIME);
    }

    public void setStartingTime(int time) {
        this.field_70180_af.func_187227_b(STARTING_TIME, (Object)time);
    }

    public boolean isStarting() {
        return (Boolean)this.field_70180_af.func_187225_a(STARTING);
    }

    public void setStarting(boolean starting, boolean playFailSound) {
        if (starting) {
            if (this.getBatteryLevel() <= 0) {
                return;
            }
            if (this.isStarted()) {
                this.setStarted(false, true, false);
                this.carStopped = true;
                return;
            }
        } else {
            if (this.carStarted || this.carStopped) {
                this.carStopped = false;
                this.carStarted = false;
                return;
            }
            if (playFailSound && this.getBatteryLevel() > 0) {
                this.playFailSound();
            }
        }
        this.field_70180_af.func_187227_b(STARTING, (Object)starting);
    }

    public float getBatterySoundPitchLevel() {
        int batteryLevel = this.getBatteryLevel();
        int startLevel = this.getMaxBatteryLevel() / 3;
        float basePitch = 1.0f - 0.002f * (float)this.getStartingTime();
        if (batteryLevel > startLevel) {
            return basePitch;
        }
        int levelUnder = startLevel - batteryLevel;
        float perc = (float)levelUnder / (float)startLevel;
        float pitch = basePitch - perc / 2.3f;
        return pitch;
    }

    public float getBatteryPercentage() {
        return (float)this.getBatteryLevel() / (float)this.getMaxBatteryLevel();
    }

    public void setBatteryLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level > this.getMaxBatteryLevel()) {
            level = this.getMaxBatteryLevel();
        }
        this.field_70180_af.func_187227_b(BATTERY_LEVEL, (Object)level);
    }

    public int getBatteryLevel() {
        return (Integer)this.field_70180_af.func_187225_a(BATTERY_LEVEL);
    }

    public int getMaxBatteryLevel() {
        return 1000;
    }

    @Override
    public void updateSounds() {
        if (!this.isStarted() && this.isStarting()) {
            this.checkStartingLoop();
        }
        super.updateSounds();
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBatteryLevel(compound.func_74762_e("battery"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("battery", this.getBatteryLevel());
    }

    @SideOnly(value=Side.CLIENT)
    public void checkStartingLoop() {
        if (!this.isSoundPlaying((ISound)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this.field_70170_p, this, this.getStartingSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.startingLoop, this.field_70170_p);
        }
    }

    @Override
    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume, this.getBatterySoundPitchLevel());
    }
}

