/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.net.MessageToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class MessageControlCar
extends MessageToServer<MessageControlCar> {
    private boolean forward;
    private boolean backward;
    private boolean left;
    private boolean right;
    private UUID uuid;

    public MessageControlCar() {
        this.forward = false;
        this.backward = false;
        this.left = false;
        this.right = false;
        this.uuid = new UUID(0L, 0L);
    }

    public MessageControlCar(boolean forward, boolean backward, boolean left, boolean right, EntityPlayer player) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.uuid = player.func_110124_au();
    }

    @Override
    public void execute(EntityPlayer player, MessageControlCar message) {
        if (!player.func_110124_au().equals(message.uuid)) {
            System.out.println("---------UUID was not the same-----------");
            return;
        }
        Entity e = player.func_184187_bx();
        if (!(e instanceof EntityCarBase)) {
            return;
        }
        EntityCarBase car = (EntityCarBase)e;
        car.updateControls(message.forward, message.backward, message.left, message.right, player);
    }

    public void fromBytes(ByteBuf buf) {
        this.forward = buf.readBoolean();
        this.backward = buf.readBoolean();
        this.left = buf.readBoolean();
        this.right = buf.readBoolean();
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.uuid = new UUID(l1, l2);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.backward);
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }
}

