/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.util.AbstractJSONConfig;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@SideOnly(value=Side.CLIENT)
public class BiomeTextureConfig
extends AbstractJSONConfig<BiomeTextureMap> {
    private static final int VERSION = 2;
    private final TextureSetMap textureSetMap;

    public BiomeTextureConfig(File file, TextureSetMap textureSetMap) {
        super(file);
        this.textureSetMap = textureSetMap;
    }

    @Override
    public int currentVersion() {
        return 2;
    }

    @Override
    protected void loadData(JsonObject json, BiomeTextureMap data, int version) {
        if (version == 0) {
            Log.warn("Too many biome textures changed since config version 0, disregarding this config entirely", new Object[0]);
            return;
        }
        if (version == 1) {
            Log.warn("Config version 1 no longer supported, config file will be reset We now use resource location to identify biomes", new Object[0]);
            return;
        }
        for (Map.Entry entry : json.entrySet()) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation((String)entry.getKey()));
            if (biome == null) {
                Log.warn("Unknown biome in texture map: %s", entry.getKey());
                continue;
            }
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                ResourceLocation[] textures = new ResourceLocation[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    String path = array.get(i).getAsString();
                    textures[i] = new ResourceLocation(path);
                }
                data.setTexture(biome, new TextureSet(null, textures));
                Log.info("Registered %d custom texture(s) for biome %s", textures.length, biome.getRegistryName().toString());
                continue;
            }
            String name = ((JsonElement)entry.getValue()).getAsString();
            if (this.textureSetMap.isRegistered(name)) {
                data.setTexture(biome, this.textureSetMap.getByName(name));
                Log.info("Registered texture set %s for biome %s", name, biome.getRegistryName().toString());
                continue;
            }
            Log.warn("Unknown texture set %s for biome %s", name, biome.getRegistryName().toString());
        }
    }

    @Override
    protected void saveData(JsonObject json, BiomeTextureMap data) {
        ArrayList<Biome> keys = new ArrayList<Biome>(data.biomeTextureMap.keySet());
        Collections.sort(keys, Comparator.comparing(IForgeRegistryEntry.Impl::getRegistryName));
        for (Biome key : keys) {
            int biomeID = Biome.func_185362_a((Biome)key);
            if (biomeID < 0 || !AntiqueAtlasMod.instance.jeidPresent && biomeID >= 256) continue;
            json.addProperty(key.getRegistryName().toString(), data.biomeTextureMap.get((Object)key).name);
        }
    }
}

