/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.blocks.BlockACBasic;
import com.shinoow.abyssalcraft.common.blocks.BlockACStone;
import com.shinoow.abyssalcraft.common.entity.EntityLesserShoggoth;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShoggothOoze
extends BlockACBasic {
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)1, (int)8);
    protected static final AxisAlignedBB[] OOZE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockShoggothOoze() {
        super(Material.field_151578_c, 1.0f, 1.0f, SoundType.field_185855_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)));
        this.func_149675_a(ACConfig.oozeExpire);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return OOZE_AABB[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LAYERS) < 5;
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 8;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        int i = (Integer)blockState.func_177229_b((IProperty)LAYERS) - 1;
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, (double)((float)i * 0.125f), axisalignedbb.field_72334_f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof EntityLesserShoggoth)) {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
            if (entity instanceof EntityLivingBase && !world.field_72995_K) {
                EntityLivingBase e = (EntityLivingBase)entity;
                ItemStack legs = e.func_184582_a(EntityEquipmentSlot.LEGS);
                ItemStack feet = e.func_184582_a(EntityEquipmentSlot.FEET);
                if (e.field_70173_aa % 60 == 0 && !legs.func_190926_b() && legs.func_77973_b() != ACItems.ethaxium_leggings) {
                    legs.func_77972_a(1, e);
                }
                if (e.field_70173_aa % 40 == 0 && !feet.func_190926_b() && feet.func_77973_b() != ACItems.ethaxium_boots) {
                    feet.func_77972_a(1, e);
                }
            }
        }
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (ACConfig.oozeExpire && !par1World.field_72995_K && par5Random.nextInt(10) == 0 && par1World.func_175671_l(pos.func_177984_a()) >= 13) {
            if ((Integer)state.func_177229_b((IProperty)LAYERS) == 8) {
                par1World.func_175656_a(pos, this.getState(par1World));
            } else if ((Integer)state.func_177229_b((IProperty)LAYERS) > 1) {
                par1World.func_175656_a(pos, state.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)LAYERS) - 1)));
            } else {
                par1World.func_175698_g(pos);
            }
        }
    }

    private IBlockState getState(World world) {
        if (world.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id) {
            return ACBlocks.abyssal_sand.func_176223_P();
        }
        if (world.field_73011_w.getDimension() == ACLib.dreadlands_id) {
            return ACBlocks.dreadlands_dirt.func_176223_P();
        }
        if (world.field_73011_w.getDimension() == ACLib.omothol_id) {
            return ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.OMOTHOL_STONE));
        }
        if (world.field_73011_w.getDimension() == ACLib.dark_realm_id) {
            return ACBlocks.stone.func_176223_P();
        }
        if (world.field_73011_w.getDimension() == -1) {
            return Blocks.field_150424_aL.func_176223_P();
        }
        if (world.field_73011_w.getDimension() == 1) {
            return Blocks.field_150377_bs.func_176223_P();
        }
        return Blocks.field_150346_d.func_176223_P();
    }

    public int func_149738_a(World worldIn) {
        return ACConfig.oozeExpire ? 200 : super.func_149738_a(worldIn);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        return block != ACBlocks.shoggoth_biomass && iblockstate != ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.MONOLITH_STONE)) ? (iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b()) ? true : (block == this && (Integer)iblockstate.func_177229_b((IProperty)LAYERS) == 8 ? true : iblockstate.func_185914_p() && iblockstate.func_185904_a().func_76230_c())) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if ((Integer)state.func_177229_b((IProperty)LAYERS) < 8) {
            this.checkAndDropBlock(worldIn, pos, state);
        }
    }

    private boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        return iblockstate.func_177230_c() == this && (Integer)iblockstate.func_177229_b((IProperty)LAYERS) >= (Integer)blockState.func_177229_b((IProperty)LAYERS) ? true : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LAYERS) == 1;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) - 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LAYERS}).build();
    }
}

