/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.server;

import com.shinoow.abyssalcraft.api.spell.SpellUtils;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class MobSpellMessage
extends AbstractMessage.AbstractServerMessage<MobSpellMessage> {
    private int id;
    private int spell;

    public MobSpellMessage() {
    }

    public MobSpellMessage(int id, int spell) {
        this.id = id;
        this.spell = spell;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.id = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.spell = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.id, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.spell, (int)5);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        Entity e = player.field_70170_p.func_73045_a(this.id);
        if (e == null) {
            return;
        }
        if (e instanceof EntityLivingBase && SpellUtils.canPlayerHurt(player, e)) {
            EntityLivingBase target = (EntityLivingBase)e;
            switch (this.spell) {
                case 0: {
                    if (target.field_70128_L || !target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76348_h().func_151518_m(), 5.0f)) break;
                    player.func_70691_i(5.0f);
                    BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
                    BlockPos pos1 = target.func_180425_c();
                    Vec3d vec = new Vec3d((Vec3i)pos1.func_177973_b((Vec3i)pos)).func_72432_b();
                    double d = Math.sqrt(pos1.func_177951_i((Vec3i)pos));
                    int i = 0;
                    while ((double)i < d * 15.0) {
                        double i1 = (double)i / 15.0;
                        double xp = (double)pos.func_177958_n() + vec.field_72450_a * i1 + 0.5;
                        double yp = (double)pos.func_177956_o() + vec.field_72448_b * i1 + 0.5;
                        double zp = (double)pos.func_177952_p() + vec.field_72449_c * i1 + 0.5;
                        ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.FLAME, xp, yp, zp, 0, vec.field_72450_a * 0.1, 0.15, vec.field_72449_c * 0.1, 1.0, new int[0]);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    target.field_70179_y = 0.0;
                    target.field_70181_x = 0.0;
                    target.field_70159_w = 0.0;
                    target.func_70031_b(false);
                    target.field_70160_al = false;
                    target.field_70122_E = true;
                    target.func_70110_aj();
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 14, false, false));
                    if (target.field_70173_aa % 20 != 0 || !(target.func_110143_aJ() > 1.0f)) break;
                    target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76348_h().func_151518_m(), 1.0f);
                    break;
                }
                case 2: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 6000, 0, false, false));
                    break;
                }
                case 3: {
                    ArrayList<EntityEquipmentSlot> slots = new ArrayList<EntityEquipmentSlot>();
                    for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                        if (!target.func_190630_a(slot)) continue;
                        slots.add(slot);
                    }
                    EntityEquipmentSlot removeSlot = (EntityEquipmentSlot)slots.get(player.field_70170_p.field_73012_v.nextInt(slots.size()));
                    target.func_70099_a(target.func_184582_a(removeSlot), 0.0f);
                    target.func_184201_a(removeSlot, ItemStack.field_190927_a);
                    break;
                }
                case 4: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 1200, 1));
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1200, 1));
                    target.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 1200, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 1200, 1));
                    break;
                }
                case 5: {
                    if (target instanceof EntityTameable && !((EntityTameable)target).func_152114_e((EntityLivingBase)player)) {
                        ((EntityTameable)target).func_193101_c(player);
                        target.func_70606_j(target.func_110138_aP());
                        break;
                    }
                    if (!(target instanceof AbstractHorse) || player.func_110124_au().equals(((AbstractHorse)target).func_184780_dh())) break;
                    ((AbstractHorse)target).func_110263_g(player);
                    target.func_70606_j(target.func_110138_aP());
                    break;
                }
                case 6: {
                    if (target.func_70668_bt() != EnumCreatureAttribute.UNDEAD || !target.func_184222_aU()) break;
                    player.field_70170_p.func_72900_e((Entity)target);
                    ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_HUGE, target.field_70165_t, target.field_70163_u + 2.0, target.field_70161_v, 0, 0.0, 0.0, 0.0, 1.0, new int[0]);
                    break;
                }
                case 7: {
                    if (!target.isCreatureType(EnumCreatureType.CREATURE, false) || !target.func_70631_g_() || !target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76348_h().func_151518_m(), 200.0f)) break;
                    for (EntityLivingBase mob : player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(50.0))) {
                        if (!mob.isCreatureType(EnumCreatureType.MONSTER, false)) continue;
                        this.teleportRandomly(mob, player.field_70170_p, player);
                    }
                    break;
                }
            }
        }
    }

    protected boolean teleportRandomly(EntityLivingBase entity, World world, EntityPlayer player) {
        double d0 = entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 64.0;
        double d1 = entity.field_70163_u + (double)(world.field_73012_v.nextInt(64) - 32);
        double d2 = entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 64.0;
        for (int tries = 0; player.func_70011_f(d0, d1, d2) < 50.0 && tries != 20; ++tries) {
            d0 = entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 96.0;
            if (!this.teleportTo(d0, d1 = entity.field_70163_u + (double)(world.field_73012_v.nextInt(64) - 32), d2 = entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 96.0, entity, world)) continue;
            return true;
        }
        return this.teleportTo(d0, d1, d2, entity, world);
    }

    protected boolean teleportTo(double par1, double par3, double par5, EntityLivingBase entity, World world) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = entity.field_70165_t;
        double d4 = entity.field_70163_u;
        double d5 = entity.field_70161_v;
        entity.field_70165_t = event.getTargetX();
        entity.field_70163_u = event.getTargetY();
        entity.field_70161_v = event.getTargetZ();
        boolean flag = false;
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (world.func_175667_e(pos)) {
            boolean flag1 = false;
            while (!flag1 && pos.func_177956_o() > 0) {
                BlockPos pos1 = pos.func_177977_b();
                IBlockState block = world.func_180495_p(pos1);
                if (block.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                pos = pos1;
            }
            if (flag1) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.field_70165_t - d3) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d8 = d4 + (entity.field_70163_u - d4) * d6 + world.field_73012_v.nextDouble() * (double)entity.field_70131_O;
            double d9 = d5 + (entity.field_70161_v - d5) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        world.func_184134_a(d3, d4, d5, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }
}

