/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.modules.tinkers.materials;

import com.teamacronymcoders.contenttweaker.modules.tinkers.materials.CoTTConMaterial;
import com.teamacronymcoders.contenttweaker.modules.tinkers.traits.TConTraitRepresentation;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.contenttweaker.tconstruct.Material")
@ZenRegister
@ModOnly(value="tconstruct")
public class TConMaterialRepresentation {
    private final Material material;

    public TConMaterialRepresentation(Material material) {
        this.material = material;
    }

    public static TConMaterialRepresentation getFromString(String identifier) {
        Material material = TinkerRegistry.getMaterial((String)identifier);
        if (material == null || material == Material.UNKNOWN) {
            CraftTweakerAPI.logError((String)("Cannot identify material <ticonmaterial:" + identifier + ">"));
            return null;
        }
        return new TConMaterialRepresentation(material);
    }

    @ZenMethod
    public void addItem(IIngredient item, @Optional(valueLong=1L) int amountNeeded, @Optional(valueLong=144L) int amountMatched) {
        if (item instanceof IItemStack) {
            this.material.addItem(CraftTweakerMC.getItemStack((IIngredient)item), amountNeeded, amountMatched);
        } else if (item instanceof IOreDictEntry) {
            this.material.addItem(((IOreDictEntry)item).getName(), amountNeeded, amountMatched);
        } else {
            for (IItemStack itemStack : item.getItems()) {
                this.addItem((IIngredient)itemStack, amountNeeded, amountMatched);
            }
        }
    }

    @ZenMethod
    public void addTrait(TConTraitRepresentation trait, @Optional String dependencies) {
        if (trait == null) {
            CraftTweakerAPI.logError((String)("Trying to add null trait to material " + this.material.identifier));
        } else if (this.material instanceof CoTTConMaterial) {
            ((CoTTConMaterial)this.material).addTrait(trait.getTrait().getIdentifier(), dependencies);
        } else {
            CraftTweakerAPI.logError((String)("Trying to add trait " + trait.getIdentifier() + " to nonCoT Material + " + this.material.identifier));
        }
    }

    @ZenMethod
    public void addTrait(String trait, @Optional String dependencies) {
        if (this.material instanceof CoTTConMaterial) {
            ((CoTTConMaterial)this.material).addTrait(trait, dependencies);
        } else {
            CraftTweakerAPI.logError((String)("Trying to add trait " + trait + " to nonCoT Material + " + this.material.identifier));
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    @ZenGetter(value="commandString")
    public String toCommandString() {
        return "<ticonmaterial:" + this.material.getIdentifier() + ">";
    }

    @ZenGetter(value="identifier")
    public String getIdentifier() {
        return this.material.identifier;
    }
}

