/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.music;

import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicCapabilities;
import pokefenn.totemic.api.music.MusicAPI;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.tileentity.totem.TotemState;
import pokefenn.totemic.util.EntityUtil;

public class MusicApiImpl
implements MusicAPI {
    @Override
    public boolean playMusic(World world, double x, double y, double z, @Nullable Entity entity, MusicInstrument instr) {
        return this.playMusic(world, x, y, z, entity, instr, 5, instr.getBaseOutput());
    }

    @Override
    public boolean playMusic(Entity entity, MusicInstrument instr) {
        return this.playMusic(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity, instr, 5, instr.getBaseOutput());
    }

    @Override
    public boolean playMusic(World world, BlockPos pos, @Nullable Entity entity, MusicInstrument instr) {
        return this.playMusic(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity, instr);
    }

    @Override
    @Deprecated
    public boolean playMusic0(World world, double x, double y, double z, @Nullable Entity entity, MusicInstrument instr, int range, int amount) {
        return this.playMusic(world, x, y, z, entity, instr, range, amount);
    }

    @Override
    public boolean playMusic(World world, double x, double y, double z, @Nullable Entity entity, MusicInstrument instr, int range, int amount) {
        if (range == 0 || amount == 0) {
            Totemic.logger.error("", (Throwable)new IllegalArgumentException("The meanings of the playMusic parameters have changed, they are no longer bonus range and amount."));
        }
        return this.getClosestAcceptor(world, x, y, z, range, range).map(acc -> acc.acceptMusic(instr, amount, x, y, z, entity)).orElse(false);
    }

    @Override
    public boolean playSelector(World world, double x, double y, double z, @Nullable Entity entity, MusicInstrument instr) {
        return this.playSelector(world, x, y, z, entity, instr, 5);
    }

    @Override
    public boolean playSelector(Entity entity, MusicInstrument instr) {
        return this.playSelector(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity, instr, 5);
    }

    @Override
    public boolean playSelector(World world, BlockPos pos, @Nullable Entity entity, MusicInstrument instr) {
        return this.playSelector(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity, instr);
    }

    @Override
    public boolean playSelector(World world, double x, double y, double z, @Nullable Entity entity, MusicInstrument instr, int range) {
        Optional<TotemState> totemState = this.getClosestAcceptor(world, x, y, z, range, range).filter(acc -> acc instanceof TotemState).map(acc -> (TotemState)acc).filter(TotemState::canSelect);
        totemState.ifPresent(t -> t.addSelector(entity, instr));
        return totemState.isPresent();
    }

    @Override
    public Optional<MusicAcceptor> getClosestAcceptor(World world, double x, double y, double z, int horizontalRadius, int verticalRadius) {
        return EntityUtil.getTileEntitiesInRange(TileEntity.class, world, new BlockPos(x, y, z), horizontalRadius, verticalRadius).stream().peek(tile -> {
            if (tile instanceof MusicAcceptor && !tile.hasCapability(TotemicCapabilities.MUSIC_ACCEPTOR, null)) {
                Totemic.logger.error("Directly implementing MusicAcceptor is no longer supported! Expose it as Capability instead, or in addition. Affected tile entity: {}", tile);
            }
        }).filter(tile -> tile.hasCapability(TotemicCapabilities.MUSIC_ACCEPTOR, null)).min(Comparator.comparing(tile -> tile.func_145835_a(x, y, z))).map(tile -> (MusicAcceptor)tile.getCapability(TotemicCapabilities.MUSIC_ACCEPTOR, null));
    }
}

