/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.network;

import com.jozufozu.yoyos.common.EntityYoyo;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCollectedDrops
implements IMessage {
    private int yoyoID;
    private ItemStack[] drops;

    public MessageCollectedDrops() {
    }

    public MessageCollectedDrops(EntityYoyo yoyo) {
        this.yoyoID = yoyo.func_145782_y();
        this.drops = new ItemStack[yoyo.collectedDrops.size()];
        for (int i = 0; i < yoyo.collectedDrops.size(); ++i) {
            this.drops[i] = yoyo.collectedDrops.get(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.yoyoID = buf.readInt();
        int length = buf.readInt();
        this.drops = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            this.drops[i] = this.readBigItemStack(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.yoyoID);
        buf.writeInt(this.drops.length);
        for (ItemStack drop : this.drops) {
            this.writeBigItemStack(buf, drop);
        }
    }

    private void writeBigItemStack(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeInt(stack.func_190916_E());
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77973_b().getNBTShareTag(stack);
            }
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbttagcompound);
        }
    }

    private ItemStack readBigItemStack(ByteBuf buf) {
        short i = buf.readShort();
        if (i < 0) {
            return ItemStack.field_190927_a;
        }
        int j = buf.readInt();
        short k = buf.readShort();
        ItemStack itemstack = new ItemStack(Item.func_150899_d((int)i), j, (int)k);
        itemstack.func_77982_d(ByteBufUtils.readTag((ByteBuf)buf));
        return itemstack;
    }

    public static class Handler
    implements IMessageHandler<MessageCollectedDrops, IMessage> {
        @Nullable
        public IMessage onMessage(MessageCollectedDrops message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                Entity maybeYoYo = mc.field_71441_e.func_73045_a(message.yoyoID);
                if (maybeYoYo instanceof EntityYoyo) {
                    EntityYoyo yoyo = (EntityYoyo)maybeYoYo;
                    yoyo.collectedDrops.clear();
                    Collections.addAll(yoyo.collectedDrops, message.drops);
                }
            });
            return null;
        }
    }
}

