/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers.materials;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.jozufozu.yoyos.tinkers.materials.AxleMaterialStats;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;

public class CordMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Length = "stat.cord.length.name";
    public static final String LOC_LengthDesc = "stat.cord.length.desc";
    public static final String COLOR_Length = CustomFontColor.encodeColor((int)11, (int)60, (int)232);
    public final float friction;
    public final float length;

    public CordMaterialStats(float friction, float length) {
        super("cord");
        this.friction = friction;
        this.length = length;
    }

    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)AxleMaterialStats.formatFriction(this.friction), (Object)CordMaterialStats.formatLength(this.length));
    }

    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate((String)"stat.axle.friction.desc", (Object[])new Object[0]), (Object)Util.translate((String)LOC_LengthDesc, (Object[])new Object[0]));
    }

    public static String formatLength(float length) {
        return CordMaterialStats.formatNumber((String)LOC_Length, (String)COLOR_Length, (float)length);
    }

    @Nullable
    public static CordMaterialStats deserialize(JsonObject material) throws JsonParseException {
        if (!JsonUtils.func_151204_g((JsonObject)material, (String)"cord")) {
            return null;
        }
        JsonObject cord = JsonUtils.func_152754_s((JsonObject)material, (String)"cord");
        float friction = JsonUtils.func_151217_k((JsonObject)cord, (String)"friction");
        float length = JsonUtils.func_151217_k((JsonObject)cord, (String)"length");
        return new CordMaterialStats(friction, length);
    }
}

