/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.ai;

import com.tmtravlr.jaff.entities.EntityFish;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFindLiquid
extends EntityAIBase {
    private EntityFish fish;
    private BlockPos liquidPos;
    private boolean water;
    private boolean lava;
    private double movementSpeed;
    private World world;

    public EntityAIFindLiquid(EntityFish creature, double speed, boolean doWater, boolean doLava) {
        this.fish = creature;
        this.movementSpeed = speed;
        this.water = doWater;
        this.lava = doLava;
        this.world = creature.field_70170_p;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return !this.isInLiquid();
    }

    public boolean func_75253_b() {
        return !this.isInCorrectMaterial();
    }

    public void func_75249_e() {
        int x = MathHelper.func_76128_c((double)this.fish.field_70165_t) + this.fish.func_70681_au().nextInt(3) - 1;
        int z = MathHelper.func_76128_c((double)this.fish.field_70161_v) + this.fish.func_70681_au().nextInt(3) - 1;
        this.fish.func_70605_aq().func_75642_a(0.5 + (double)x, this.fish.field_70163_u, 0.5 + (double)z, this.movementSpeed);
    }

    public void func_75246_d() {
        if (this.fish.func_70681_au().nextInt(20) == 0) {
            if (this.liquidPos == null) {
                this.liquidPos = this.findLiquid();
                if (this.liquidPos != null) {
                    this.fish.func_70605_aq().func_75642_a(0.5 + (double)this.liquidPos.func_177958_n(), this.fish.field_70163_u, 0.5 + (double)this.liquidPos.func_177952_p(), this.movementSpeed);
                } else {
                    int x = MathHelper.func_76128_c((double)this.fish.field_70165_t) + this.fish.func_70681_au().nextInt(3) - 1;
                    int z = MathHelper.func_76128_c((double)this.fish.field_70161_v) + this.fish.func_70681_au().nextInt(3) - 1;
                    this.fish.func_70605_aq().func_75642_a(0.5 + (double)x, this.fish.field_70163_u, 0.5 + (double)z, this.movementSpeed);
                }
            } else if (!this.isCorrectMaterial(this.world.func_180495_p(this.liquidPos).func_185904_a())) {
                this.liquidPos = null;
            }
        }
    }

    private BlockPos findLiquid() {
        Random random = this.fish.func_70681_au();
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)(this.fish.field_70165_t + (double)random.nextInt(10) - 5.0));
            Material material = this.world.func_180495_p(new BlockPos(x, y = MathHelper.func_76128_c((double)(this.fish.func_174813_aQ().field_72338_b + (double)random.nextInt(10) - 5.0)), z = MathHelper.func_76128_c((double)(this.fish.field_70161_v + (double)random.nextInt(10) - 5.0)))).func_185904_a();
            if (!this.isCorrectMaterial(material)) continue;
            return new BlockPos(x, y, z);
        }
        return null;
    }

    private boolean isCorrectMaterial(Material material) {
        return this.water && material == Material.field_151586_h || this.lava && material == Material.field_151587_i;
    }

    private boolean isInCorrectMaterial() {
        return this.water && this.fish.func_70090_H() || this.lava && this.fish.func_180799_ab();
    }

    private boolean isInLiquid() {
        return this.fish.func_70090_H() || this.fish.func_180799_ab();
    }
}

