/*
 * Decompiled with CFR 0.152.
 */
package igwmod.gui.tabs;

import igwmod.TickHandler;
import igwmod.api.WikiRegistry;
import igwmod.gui.GuiWiki;
import igwmod.gui.IPageLink;
import igwmod.gui.IReservedSpace;
import igwmod.gui.LocatedEntity;
import igwmod.gui.LocatedTexture;
import igwmod.gui.tabs.IWikiTab;
import igwmod.lib.Textures;
import igwmod.lib.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class EntityWikiTab
implements IWikiTab {
    private static Entity curEntity;
    private static Entity tabEntity;

    @Override
    public String getName() {
        return "igwmod.wikitab.entities.name";
    }

    @Override
    public ItemStack renderTabIcon(GuiWiki gui) {
        if (tabEntity == null) {
            EntityPlayerSP player = gui.field_146297_k.field_71439_g;
            tabEntity = new EntityCreeper(player.field_70170_p);
        }
        EntityWikiTab.drawEntity(tabEntity, 18, 28, 0.6f, 0.0f);
        return null;
    }

    @Override
    public List<IReservedSpace> getReservedSpaces() {
        ArrayList<IReservedSpace> reservedSpaces = new ArrayList<IReservedSpace>();
        reservedSpaces.add(new LocatedTexture(Textures.GUI_ENTITIES, 40, 74, 36, 153));
        return reservedSpaces;
    }

    @Override
    public List<IPageLink> getPages(int[] indexes) {
        List<Class<? extends Entity>> allEntries = WikiRegistry.getEntityPageEntries();
        ArrayList<IPageLink> pages = new ArrayList<IPageLink>();
        if (indexes == null) {
            for (int i = 0; i < allEntries.size(); ++i) {
                pages.add(new LocatedEntity(allEntries.get(i), 41, 77 + i * 36));
            }
        } else {
            for (int i = 0; i < indexes.length; ++i) {
                pages.add(new LocatedEntity(allEntries.get(indexes[i]), 41, 77 + i * 36));
            }
        }
        return pages;
    }

    @Override
    public int pagesPerTab() {
        return 4;
    }

    @Override
    public int pagesPerScroll() {
        return 1;
    }

    @Override
    public int getSearchBarAndScrollStartY() {
        return 61;
    }

    @Override
    public void renderForeground(GuiWiki gui, int mouseX, int mouseY) {
    }

    @Override
    public void renderBackground(GuiWiki gui, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (curEntity != null) {
            EntityWikiTab.drawEntity(curEntity, gui.getGuiLeft() + 65, gui.getGuiTop() + 49, 0.7f, 0.0f);
        }
    }

    @Override
    public void onMouseClick(GuiWiki gui, int mouseX, int mouseY, int mouseKey) {
    }

    public static void drawEntity(Entity entity, int x, int y, float size, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float maxHitboxComponent = Math.max(1.0f, Math.max(entity.field_70130_N, entity.field_70131_O));
        int scale = (int)(40.0f * size / maxHitboxComponent);
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-TickHandler.ticksExisted), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)((float)entity.func_70033_W()), (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @Override
    public void onPageChange(GuiWiki gui, String pageName, Object ... metadata) {
        if (metadata.length > 0 && metadata[0] instanceof Entity) {
            curEntity = Util.getEntityForClass(((Entity)metadata[0]).getClass());
        }
    }
}

