/*
 * Decompiled with CFR 0.152.
 */
package igwmod.gui.tabs;

import igwmod.IGWMod;
import igwmod.InfoSupplier;
import igwmod.gui.GuiWiki;
import igwmod.gui.LocatedTexture;
import igwmod.gui.tabs.BaseWikiTab;
import igwmod.lib.IGWLog;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.lwjgl.opengl.GL11;

public class ServerWikiTab
extends BaseWikiTab {
    private String serverName;
    private ItemStack iconStack = ItemStack.field_190927_a;
    private LocatedTexture icon;

    public ServerWikiTab() {
        File[] files;
        List<String> info = InfoSupplier.getInfo("igwmod", "server/properties", true);
        if (info != null) {
            for (String s : info) {
                String[] entry = s.split("=");
                if (entry[0].equals("server_name")) {
                    this.serverName = entry[1];
                }
                if (!entry[0].equals("icon_item")) continue;
                String[] icon = entry[1].split(":");
                this.iconStack = GameRegistry.makeItemStack((String)(icon[0] + ":" + icon[1]), (int)0, (int)1, (String)"");
                if (!this.iconStack.func_190926_b()) continue;
                IGWLog.warning("Couldn't find a server tab icon item stack for the name: " + entry[1]);
            }
        }
        if (this.iconStack.func_190926_b()) {
            this.icon = new LocatedTexture(new ResourceLocation("server/tab_icon.png"), 5, 10, 27, 27);
        }
        for (File file : files = new File(IGWMod.proxy.getSaveLocation() + File.separator + "igwmod").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".txt");
            }
        })) {
            if (file.getName().equals("properties.txt")) continue;
            this.pageEntries.add(file.getName().substring(0, file.getName().length() - 4));
        }
    }

    @Override
    public String getName() {
        return this.serverName != null ? this.serverName : "Missing 'igwmod/properties.txt' with 'server_name=' key";
    }

    @Override
    public ItemStack renderTabIcon(GuiWiki gui) {
        if (!this.iconStack.func_190926_b()) {
            return this.iconStack;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-6.0, (double)0.0);
        this.icon.renderBackground(null, 0, 0);
        GL11.glPopMatrix();
        return null;
    }

    @Override
    protected String getPageName(String pageEntry) {
        return pageEntry;
    }

    @Override
    protected String getPageLocation(String pageEntry) {
        return "server/" + pageEntry;
    }
}

