/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.common.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import tv.darkosto.sevtweaks.SevTweaks;
import tv.darkosto.sevtweaks.common.util.BiomeDebugTable;

public class CommandSevTweaks
extends CommandBase {
    private static final String[] COMMANDS = new String[]{"debugger", "gamestage"};
    private static final String[] GSCOMMANDS = new String[]{"init", "sync"};
    private static final String[] DEBUGGER_COMMANDS = new String[]{"biomes"};

    @Nonnull
    public String func_71517_b() {
        return "sevtweaks";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/sevtweaks <action> [arguments...]";
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos blockPos) {
        if (args.length == 1) {
            return CommandSevTweaks.func_71530_a((String[])args, (String[])COMMANDS);
        }
        String identifier = args[0].toLowerCase();
        if (identifier.equals("gamestage")) {
            return CommandSevTweaks.func_71530_a((String[])args, (String[])GSCOMMANDS);
        }
        if (identifier.equals("debugger")) {
            return CommandSevTweaks.func_71530_a((String[])args, (String[])DEBUGGER_COMMANDS);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNot enough arguments."));
            return;
        }
        String identifier = args[0];
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.sevtweaks.invalid.option", new Object[]{"Testing"}));
            return;
        }
        String subIdentifier = args[1];
        switch (identifier.toLowerCase()) {
            case "gamestage": {
                switch (subIdentifier.toLowerCase()) {
                    case "init": {
                        if (SevTweaks.scoreboard.init(server)) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.sevtweaks.gsscore.success", new Object[0]));
                            return;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.sevtweaks.gsscore.failed", new Object[0]));
                        return;
                    }
                    case "sync": {
                        SevTweaks.scoreboard.syncPlayers(server);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.sevtweaks.gssync.success", new Object[0]));
                        return;
                    }
                }
            }
            case "debugger": {
                switch (subIdentifier.toLowerCase()) {
                    case "biomes": {
                        if (BiomeDebugTable.createFile()) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.sevtweaks.debugger.biomes.success", new Object[0]));
                            return;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.sevtweaks.debugger.biomes.failed", new Object[0]));
                        return;
                    }
                }
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7c" + identifier + " is not valid option! Valid options: " + Arrays.toString(COMMANDS)));
    }
}

