/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.common.compat.modules;

import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import journeymap.client.model.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import net.darkhax.gamestages.event.GameStageEvent;
import net.darkhax.jmapstages.JMapStages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tv.darkosto.sevtweaks.SevTweaks;
import tv.darkosto.sevtweaks.common.compat.ICompat;
import tv.darkosto.sevtweaks.network.MarkersSyncPacket;
import tv.darkosto.sevtweaks.network.SevTweaksPacketHandler;

public class AaToJmWaypoints
extends ICompat {
    @SubscribeEvent
    public void gamestageEvent(GameStageEvent.Added event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getStageName().equals(JMapStages.stageWaypoint)) {
            Collection<Marker> markers = AaToJmWaypoints.getAaMarkers(event.getEntityPlayer());
            if (markers == null || markers.isEmpty()) {
                return;
            }
            SevTweaksPacketHandler.INSTANCE.sendTo((IMessage)new MarkersSyncPacket(markers), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    public static Collection<Marker> getAaMarkers(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return null;
        }
        HashSet playerAtlases = new HashSet(AtlasAPI.getPlayerAtlases((EntityPlayer)player));
        ArrayList<Marker> markers = new ArrayList<Marker>();
        Iterator iterator = playerAtlases.iterator();
        while (iterator.hasNext()) {
            int atlasId = (Integer)iterator.next();
            MarkersData markersData = (MarkersData)player.field_70170_p.func_72943_a(MarkersData.class, String.format("aaMarkers_%d", atlasId));
            if (markersData == null) continue;
            Set visitedDimensions = markersData.getVisitedDimensions();
            Iterator iterator2 = visitedDimensions.iterator();
            while (iterator2.hasNext()) {
                int dimension = (Integer)iterator2.next();
                DimensionMarkersData dimensionMarkersData = markersData.getMarkersDataInDimension(dimension);
                Collection markersInDimension = dimensionMarkersData.getAllMarkers();
                markers.addAll(markersInDimension);
            }
        }
        return markers;
    }

    @SideOnly(value=Side.CLIENT)
    public static void doSync(Collection<Marker> markers) {
        SevTweaks.logger.info("{} markers from Antique Atlas are being imported into JourneyMap", (Object)markers.size());
        Random random = new Random();
        for (Marker marker : markers) {
            WaypointStore.INSTANCE.add(new Waypoint(marker.getLocalizedLabel(), new BlockPos(marker.getX(), 70, marker.getZ()), marker.getType().equals("antiqueatlas:nether_portal") ? new Color(134, 0, 175) : new Color(random.nextFloat(), random.nextFloat(), random.nextFloat()), marker.getType().equals("antiqueatlas:tomb") ? Waypoint.Type.Death : Waypoint.Type.Normal, Integer.valueOf(marker.getDimension())).setDirty());
        }
        WaypointStore.INSTANCE.bulkSave();
    }

    @Override
    public void preInit() {
        if (!Loader.isModLoaded((String)"journeymap") || !Loader.isModLoaded((String)"jmapstages")) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }
}

