/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.ModItems;
import animalium.configs.ConfigHandler;
import animalium.entities.EntityDogPart;
import animalium.entities.IEntityMultiPartDog;
import animalium.entities.ai.EntityAIWildDogLeap;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityWildDog
extends EntityMob
implements IEntityMultiPartDog {
    public EntityDogPart[] dogPartArray;
    public EntityDogPart dogPartHead = new EntityDogPart(this, "head", 0.5f, 0.5f);

    public EntityWildDog(World world) {
        super(world);
        this.dogPartArray = new EntityDogPart[]{this.dogPartHead};
        this.func_70105_a(0.9f, 1.2f);
        if (world != null && !world.field_72995_K) {
            if (ConfigHandler.WILD_DOG_ATTACK_MOBS) {
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, true, null));
            }
            if (ConfigHandler.WILD_DOG_ATTACK_CREATURES) {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, null));
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWildDogLeap((EntityLiving)this, 0.5f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIWildDogAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean func_70686_a(Class entity) {
        return EntityWildDog.class != entity;
    }

    protected boolean func_70814_o() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.func_130014_f_().func_175642_b(EnumSkyBlock.BLOCK, blockpos) < 8;
    }

    public boolean func_70601_bi() {
        if (this.isDimBlacklisted(this.field_71093_bK).booleanValue()) {
            return false;
        }
        return this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && this.func_70814_o() && this.func_70058_J() && this.field_70163_u <= (double)ConfigHandler.WILD_DOG_SPAWN_Y_HEIGHT;
    }

    public boolean func_70058_J() {
        return !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    private Boolean isDimBlacklisted(int dimensionIn) {
        ArrayList<Integer> dimBlackList = new ArrayList<Integer>();
        for (int dims = 0; dims < ConfigHandler.WILD_DOG_BLACKLISTED_DIMS.length; ++dims) {
            String dimEntry = ConfigHandler.WILD_DOG_BLACKLISTED_DIMS[dims].trim();
            dimBlackList.add(Integer.valueOf(dimEntry));
        }
        if (dimBlackList.contains(dimensionIn)) {
            return true;
        }
        return false;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.func_130014_f_().field_73012_v.nextInt(5) == 0) {
            ItemStack stack = new ItemStack(ModItems.WILD_DOG_PELT);
            if (this.func_70027_ad()) {
                stack = new ItemStack(Items.field_151103_aS);
            }
            this.func_70099_a(stack, 1.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70761_aq = this.field_70177_z;
        double a = Math.toRadians(this.field_70177_z);
        double offSetX = -Math.sin(a) * -0.75;
        double offSetZ = Math.cos(a) * -0.75;
        this.dogPartHead.func_70012_b(this.field_70165_t - offSetX, this.field_70163_u + 0.7, this.field_70161_v - offSetZ, 0.0f, 0.0f);
    }

    @Override
    public boolean attackEntityFromPart(EntityDogPart dogPart, DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityPlayer || source.func_94541_c()) {
            this.attackDogFrom(source, damage);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            this.attackEntityFromPart(this.dogPartHead, source, amount);
        }
        return this.attackDogFrom(source, amount);
    }

    protected boolean attackDogFrom(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Override
    public World getWorld() {
        return this.func_130014_f_();
    }

    public Entity[] func_70021_al() {
        return this.dogPartArray;
    }

    static class AIWildDogAttack
    extends EntityAIAttackMelee {
        public AIWildDogAttack(EntityWildDog dog) {
            super((EntityCreature)dog, 0.6, false);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

