/*
 * Decompiled with CFR 0.152.
 */
package net.artdude.mekatweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.Files;
import com.google.gson.Gson;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import net.artdude.mekatweaks.GasCommands;
import net.artdude.mekatweaks.compat.jei.PluginMekanismTweaker;
import net.artdude.mekatweaks.data.CustomInfuseType;
import net.darkhax.gamestages.event.StagesSyncedEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.StringUtils;

@Mod(modid="mekatweaks", name="MekaTweaks", version="1.0.0-3", acceptedMinecraftVersions="[1.12.2]")
public class MekaTweaks {
    public static final Logger LOG = LogManager.getLogger((String)"mekatweaks");
    private static final Gson GSON = new Gson();
    private static final File infuseTypes = new File(new File("config"), "mtInfuseTypes.json");
    public static final ListMultimap<String, GasStack> GAS_STAGES = ArrayListMultimap.create();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (infuseTypes.exists()) {
            try (BufferedReader reader = Files.newReader((File)infuseTypes, (Charset)StandardCharsets.UTF_8);){
                CustomInfuseType[] infuseTypes;
                for (CustomInfuseType customType : infuseTypes = (CustomInfuseType[])GSON.fromJson((Reader)reader, CustomInfuseType[].class)) {
                    if (customType.getName().length() == 0) {
                        LOG.warn("[Infuse Register] Name is empty or null for an entry!");
                        continue;
                    }
                    InfuseType infuseType = new InfuseType(customType.getName().toLowerCase(), customType.getResourceLocation());
                    infuseType.unlocalizedName = String.format("%s (MT)", StringUtils.capitalise((String)customType.getName()));
                    LOG.info(String.format("[Infuse Register] Registering custom Infuse Type %s to Mekanism.", customType.getName()));
                    InfuseRegistry.registerInfuseType((InfuseType)infuseType);
                }
            }
            catch (IOException err) {
                LOG.error("Could not read {}.", (Object)infuseTypes.getName());
                LOG.catching((Throwable)err);
            }
        }
        CTChatCommand.registerCommand((CraftTweakerCommand)new GasCommands());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientSync(StagesSyncedEvent event) {
        if (Loader.isModLoaded((String)"jei")) {
            PluginMekanismTweaker.syncHiddenItems(event.getEntityPlayer());
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onClientLoadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(listener -> {
            if (Loader.isModLoaded((String)"jei")) {
                LOG.info("Resyncing JEI info.");
                PluginMekanismTweaker.syncHiddenItems((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        });
    }
}

