/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.lttweaker;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.lttweaker.CommandTableDump;
import net.darkhax.lttweaker.libs.Constants;
import net.darkhax.lttweaker.removal.IRemover;
import net.minecraft.command.ICommand;
import net.minecraft.util.Tuple;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod(modid="lttweaker", name="Loot Table Tweaker", version="1.1.14", dependencies="required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class LTTMod {
    @Mod.Instance(value="lttweaker")
    public static LTTMod instance;
    private static Field pools;
    private static Field lootEntries;
    public static Map<String, LootTable> tables;
    public static List<IRemover> removal;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        pools = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c", "c"});
        lootEntries = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"lootEntries", "field_186453_a", "a"});
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTableDump());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTablesLoad(LootTableLoadEvent event) {
        String tableName = event.getName().toString();
        tables.put(tableName, event.getTable());
        ArrayList<String> poolsToRemove = new ArrayList<String>();
        ArrayList<Tuple> entriesToRemove = new ArrayList<Tuple>();
        for (IRemover remover : removal) {
            if (remover.removeTable(tableName)) {
                event.setCanceled(true);
                break;
            }
            for (LootPool pool : LTTMod.getPools(event.getTable())) {
                String poolName = pool.getName();
                if (remover.removePool(tableName, tableName)) {
                    poolsToRemove.add(poolName);
                    continue;
                }
                for (LootEntry entry : LTTMod.getLootEntries(pool)) {
                    String entryName = entry.getEntryName();
                    if (remover.removeEntry(tableName, poolName, entryName)) {
                        entriesToRemove.add(new Tuple((Object)pool, (Object)entryName));
                        continue;
                    }
                    if (!(entry instanceof LootEntryItem)) continue;
                    LootEntryItem itemEntry = (LootEntryItem)entry;
                    if (itemEntry.field_186368_a == null || itemEntry.field_186368_a.getRegistryName() == null || !remover.removeItem(tableName, poolName, itemEntry.field_186368_a)) continue;
                    entriesToRemove.add(new Tuple((Object)pool, (Object)entryName));
                }
            }
        }
        for (String pool : poolsToRemove) {
            event.getTable().removePool(pool);
        }
        for (Tuple entry : entriesToRemove) {
            ((LootPool)entry.func_76341_a()).removeEntry((String)entry.func_76340_b());
        }
    }

    public static List<LootPool> getPools(LootTable table) {
        try {
            return (List)pools.get(table);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return new ArrayList<LootPool>();
        }
    }

    public static List<LootEntry> getLootEntries(LootPool pool) {
        try {
            return (List)lootEntries.get(pool);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        Constants.LOG.error("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    static {
        tables = new HashMap<String, LootTable>();
        removal = new ArrayList<IRemover>();
    }
}

