/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagertrades.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.crazysnailboy.mods.villagertrades.VillagerTradesMod;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static HashMap<String, String> createFileMap(String folderName, boolean loadFilesFromJar) {
        File villagersFolder;
        File configFolder;
        HashMap<String, String> fileMap = new HashMap<String, String>();
        if (loadFilesFromJar) {
            for (String fileName : FileUtils.getFileNamesFromModFolder("/assets/vtt/data/" + folderName + "/")) {
                String fileContents = FileUtils.readFileContentsFromMod("assets/vtt/data/" + folderName + "/" + fileName);
                fileMap.put(fileName, fileContents);
            }
        }
        if (!(configFolder = new File((Loader.instance().getConfigDir().getAbsolutePath() + "/" + "vtt").replace(File.separatorChar, '/').replace("/./", "/"))).exists()) {
            configFolder.mkdirs();
        }
        if ((villagersFolder = new File(configFolder, folderName)).exists()) {
            for (String fileName : FileUtils.getFileNamesFromFolder(villagersFolder.toPath())) {
                String fileContents = FileUtils.readFileContents(new File(villagersFolder, fileName));
                fileMap.put(fileName, fileContents);
            }
        } else {
            villagersFolder.mkdirs();
            for (String fileName : fileMap.keySet()) {
                FileUtils.writeFile(new File(villagersFolder, fileName), fileMap.get(fileName));
            }
        }
        return fileMap;
    }

    private static List<String> getFileNamesFromFolder(Path folderPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            Stream<Path> walk = Files.walk(folderPath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String fileName = ((Path)it.next()).getFileName().toString();
                if (!fileName.endsWith(".json")) continue;
                fileNames.add(fileName);
            }
            walk.close();
        }
        catch (Exception ex) {
            VillagerTradesMod.LOGGER.catching((Throwable)ex);
        }
        return fileNames;
    }

    private static List<String> getFileNamesFromModFolder(String resourceFolder) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            Path resourcePath;
            URI resourceUri = VillagerTradesMod.class.getResource(resourceFolder).toURI();
            if (resourceUri.getScheme().equals("jar")) {
                FileSystem fileSystem;
                try {
                    fileSystem = FileSystems.newFileSystem(resourceUri, Collections.emptyMap());
                }
                catch (FileSystemAlreadyExistsException ex) {
                    fileSystem = FileSystems.getFileSystem(resourceUri);
                }
                resourcePath = fileSystem.getPath(resourceFolder, new String[0]);
            } else {
                resourcePath = Paths.get(resourceUri);
            }
            Stream<Path> walk = Files.walk(resourcePath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String fileName = ((Path)it.next()).getFileName().toString();
                if (!fileName.endsWith(".json")) continue;
                fileNames.add(fileName);
            }
            walk.close();
        }
        catch (Exception ex) {
            VillagerTradesMod.LOGGER.catching((Throwable)ex);
        }
        return fileNames;
    }

    private static String readFileContents(File file) {
        String fileContents = "";
        try {
            FileInputStream stream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            fileContents = IOUtils.toString((InputStream)stream);
            reader.close();
            ((InputStream)stream).close();
        }
        catch (Exception ex) {
            VillagerTradesMod.LOGGER.catching((Throwable)ex);
        }
        return fileContents;
    }

    private static String readFileContentsFromMod(String fileName) {
        String fileContents = "";
        try {
            InputStream stream = VillagerTradesMod.INSTANCE.getClass().getClassLoader().getResourceAsStream(fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            fileContents = IOUtils.toString((InputStream)stream);
            reader.close();
            stream.close();
        }
        catch (Exception ex) {
            VillagerTradesMod.LOGGER.catching((Throwable)ex);
        }
        return fileContents;
    }

    private static void writeFile(File outputFile, String fileContents) {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            BufferedWriter streamWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
            streamWriter.write(fileContents);
            streamWriter.close();
            outputStream.close();
        }
        catch (Exception ex) {
            VillagerTradesMod.LOGGER.catching((Throwable)ex);
        }
    }
}

