/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.block.te;

import aroma1997.core.block.te.element.TileEntityElementBase;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.PacketTeUpdate;
import aroma1997.core.util.registry.TickRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityBase
extends TileEntity
implements ITickable {
    private Map<Class<? extends TileEntityElementBase>, TileEntityElementBase> elements;
    private Map<Capability<?>, TileEntityElementBase> capabilities;
    private boolean isLoaded = false;
    private boolean sendUpdate = true;

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        ByteBuf buf = Unpooled.buffer();
        NetworkHelper.encodeAllInClass((Object)this, buf);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        NBTTagCompound nbt = super.func_189515_b(new NBTTagCompound());
        nbt.func_74773_a("data", bytes);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        byte[] bytes = tag.func_74770_j("data");
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(bytes);
        NetworkHelper.decodeAllInClass((Object)this, buf);
    }

    public <T extends TileEntityElementBase> T addElement(T element) {
        if (this.elements == null) {
            this.elements = new IdentityHashMap<Class<? extends TileEntityElementBase>, TileEntityElementBase>();
        }
        if (this.elements.containsKey(element.getElementClass())) {
            throw new IllegalArgumentException("Element already registered.");
        }
        this.elements.put(element.getElementClass(), element);
        this.addElementCapabilities(element);
        return element;
    }

    public <T extends TileEntityElementBase> T getElement(Class<T> clazz) {
        if (this.elements == null) {
            return null;
        }
        return (T)((TileEntityElementBase)clazz.cast(this.elements.get(clazz)));
    }

    public Collection<TileEntityElementBase> getElements() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.values();
    }

    private void addElementCapabilities(TileEntityElementBase element) {
        Collection<Capability<?>> caps = element.getProvidedCapabilities(null);
        if (caps.isEmpty()) {
            return;
        }
        if (this.capabilities == null) {
            this.capabilities = new IdentityHashMap();
        }
        for (Capability<?> cap : caps) {
            TileEntityElementBase conflict = this.capabilities.put(cap, element);
            if (conflict == null) continue;
            throw new IllegalArgumentException("Multiple Elements provide the same capability.");
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (this.capabilities == null) {
            return false;
        }
        TileEntityElementBase element = this.capabilities.get(capability);
        if (element == null) {
            return false;
        }
        return element.getProvidedCapabilities(facing).contains(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        TileEntityElementBase element;
        if (this.capabilities != null && (element = this.capabilities.get(capability)) != null) {
            return element.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList elementTags = compound.func_150295_c("elements", 10);
        for (int i = 0; i < elementTags.func_74745_c(); ++i) {
            Class<?> clazz;
            NBTTagCompound current = elementTags.func_150305_b(i);
            try {
                clazz = Class.forName(current.func_74779_i("name"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            Object element = this.getElement(clazz);
            ((TileEntityElementBase)element).readFromNbt(current.func_74775_l("data"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagList elementTags = new NBTTagList();
        for (TileEntityElementBase element : this.getElements()) {
            NBTTagCompound nbt = element.writeToNbt(new NBTTagCompound());
            if (nbt.func_82582_d()) continue;
            NBTTagCompound current = new NBTTagCompound();
            current.func_74778_a("name", element.getElementClass().getName());
            current.func_74782_a("data", (NBTBase)nbt);
            elementTags.func_74742_a((NBTBase)current);
        }
        compound.func_74782_a("elements", (NBTBase)elementTags);
        return compound;
    }

    public final void func_145829_t() {
        super.func_145829_t();
        TickRegistry.WORLD.addSingleCallback(this.func_145831_w(), w -> {
            if (!this.func_145837_r() && w.func_175625_s(this.field_174879_c) == this && !this.isLoaded) {
                this.load();
            }
        });
    }

    protected void load() {
        for (TileEntityElementBase element : this.getElements()) {
            element.load();
        }
        this.isLoaded = true;
    }

    protected void unload() {
        for (TileEntityElementBase element : this.getElements()) {
            element.unload();
        }
        this.isLoaded = false;
    }

    public final void func_145843_s() {
        if (this.isLoaded) {
            this.unload();
        }
        super.func_145843_s();
    }

    public final void onChunkUnload() {
        if (this.isLoaded) {
            this.unload();
        }
        super.onChunkUnload();
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (TileEntityElementBase element : this.getElements()) {
            element.onMarkDirty();
        }
    }

    public void func_73660_a() {
        for (TileEntityElementBase element : this.getElements()) {
            element.tick();
        }
        if (this.sendUpdate && !this.field_145850_b.field_72995_K) {
            new PacketTeUpdate(this).sendPacket();
            this.sendUpdate = false;
        }
    }

    public void sendUpdates() {
        this.sendUpdate = true;
    }
}

