/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client;

import aroma1997.core.client.MiscStuff;
import aroma1997.core.client.PlayerInfo;
import aroma1997.core.log.LogHelperPre;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ThreadDownloadCape
extends Thread {
    private String username;
    private String capeURL;
    private ResourceLocation capeRL;
    private ITextureObject capeImage;
    public boolean finishedLoading = false;
    private static HashMap<String, ThreadDownloadCape> threadlist = new HashMap();

    public ThreadDownloadCape(GameProfile player) {
        String username = player.getName();
        threadlist.put(username, this);
        this.username = username;
        this.capeURL = MiscStuff.getPlayerInfo(player).get(PlayerInfo.CAPE);
        this.setDaemon(true);
        this.setName("Cape Downloader: " + username);
    }

    @Override
    public void run() {
        try {
            ThreadDownloadCape.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogHelperPre.log(Level.TRACE, "Adjusting skin for player: " + this.username);
        this.downloadImageData();
        LogHelperPre.log(Level.TRACE, "Done adjusting skin for player: " + this.username);
    }

    private void downloadImageData() {
        String[] n = this.capeURL.split("/");
        this.capeRL = new ResourceLocation("cloak/" + StringUtils.func_76338_a((String)(this.username + "-" + n[n.length - 1])));
        this.capeImage = ThreadDownloadCape.getDownloadImage(this.capeRL, this.capeURL, null, null);
        this.finishedLoading = true;
    }

    private static ITextureObject getDownloadImage(ResourceLocation rl, String url, ResourceLocation targetRL, IImageBuffer buffer) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(rl);
        if (object == null) {
            object = new ThreadDownloadImageData(null, url, targetRL, buffer);
            texturemanager.func_110579_a(rl, object);
        }
        return object;
    }

    public ITextureObject getCurrentCapeImage() {
        return this.capeImage;
    }

    public ResourceLocation getCurrentCapeRL() {
        return this.capeRL;
    }

    static synchronized void resetThreads() {
        threadlist.clear();
    }

    public static synchronized ThreadDownloadCape getThread(GameProfile player) {
        ThreadDownloadCape thread = threadlist.get(player.getName());
        if (thread == null) {
            thread = new ThreadDownloadCape(player);
            thread.start();
        }
        return thread;
    }
}

