/*
 * Decompiled with CFR 0.152.
 */
package thretcha.roadrunner;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thretcha.roadrunner.Config;

public class RoadHandler {
    public static List<UUID> ROAD_MODIFIER_UUID_LIST = new ArrayList<UUID>();
    public static List<AttributeModifier> ROAD_MODIFIER_LIST = new ArrayList<AttributeModifier>();
    public static Map<String, UUID> ROAD_BLOCKS = new HashMap<String, UUID>();
    public static String[] ROAD_BLOCK_IDS = new String[]{"", "", "", "", ""};

    public static void initRoadModifierUUIDList() {
        ROAD_MODIFIER_UUID_LIST.add(UUID.fromString("8753f773-a718-4ea8-98db-4318be0159fe"));
        ROAD_MODIFIER_UUID_LIST.add(UUID.fromString("b8b8b5b0-a92a-4721-a9ec-5b83b1950331"));
        ROAD_MODIFIER_UUID_LIST.add(UUID.fromString("8d560517-f314-47e5-8420-1b13b4740034"));
        ROAD_MODIFIER_UUID_LIST.add(UUID.fromString("6de83cb8-883b-4d6b-915c-b90e2fdfe154"));
        ROAD_MODIFIER_UUID_LIST.add(UUID.fromString("48cf6bac-5b95-44b7-b8b0-8f3e491b2c2f"));
    }

    public static void initRoadModifierList() {
        ROAD_MODIFIER_LIST.add(new AttributeModifier(ROAD_MODIFIER_UUID_LIST.get(0), "Road 1 Speed Modifier", Config.BLOCK_AMOUNT_1, Config.BLOCK_OPERATION_1));
        ROAD_MODIFIER_LIST.add(new AttributeModifier(ROAD_MODIFIER_UUID_LIST.get(1), "Road 2 Speed Modifier", Config.BLOCK_AMOUNT_2, Config.BLOCK_OPERATION_2));
        ROAD_MODIFIER_LIST.add(new AttributeModifier(ROAD_MODIFIER_UUID_LIST.get(2), "Road 3 Speed Modifier", Config.BLOCK_AMOUNT_3, Config.BLOCK_OPERATION_3));
        ROAD_MODIFIER_LIST.add(new AttributeModifier(ROAD_MODIFIER_UUID_LIST.get(3), "Road 4 Speed Modifier", Config.BLOCK_AMOUNT_4, Config.BLOCK_OPERATION_4));
        ROAD_MODIFIER_LIST.add(new AttributeModifier(ROAD_MODIFIER_UUID_LIST.get(4), "Road 5 Speed Modifier", Config.BLOCK_AMOUNT_5, Config.BLOCK_OPERATION_5));
    }

    private boolean hasRoadModifier(EntityLivingBase entity) {
        Set modifierSet = Sets.newHashSet();
        modifierSet = (Set)entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111122_c();
        Boolean ret = false;
        for (AttributeModifier modifier : modifierSet) {
            if (!ROAD_MODIFIER_LIST.contains(modifier)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private AttributeModifier getRoadModifier(EntityLivingBase entity) {
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111122_c();
        Set modifierSet = Sets.newHashSet();
        modifierSet = (Set)entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111122_c();
        AttributeModifier ret = null;
        for (AttributeModifier modifier : modifierSet) {
            if (!ROAD_MODIFIER_LIST.contains(modifier)) continue;
            ret = modifier;
            break;
        }
        return ret;
    }

    @SubscribeEvent
    public void livingEntityOnRoad(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        if (!entity.func_130014_f_().field_72995_K) {
            BlockPos position = ((EntityLivingBase)event.getEntity()).func_180425_c().func_177977_b();
            String BlockUnderEntity = entity.func_130014_f_().func_180495_p(position).func_177230_c().toString();
            if (ROAD_BLOCKS.containsKey(BlockUnderEntity) && !this.hasRoadModifier(entity)) {
                this.addCorrectRoadModifier(entity, BlockUnderEntity);
            } else if (!ROAD_BLOCKS.containsKey(BlockUnderEntity) || !this.getRoadModifier(entity).func_111167_a().equals(ROAD_BLOCKS.get(BlockUnderEntity))) {
                if (!ROAD_BLOCKS.containsKey(BlockUnderEntity) && this.hasRoadModifier(entity)) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.getRoadModifier(entity).func_111167_a());
                } else if (ROAD_BLOCKS.containsKey(BlockUnderEntity) && ROAD_BLOCKS.get(BlockUnderEntity).equals(this.getRoadModifier(entity).func_111167_a())) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.getRoadModifier(entity).func_111167_a());
                    this.addCorrectRoadModifier(entity, BlockUnderEntity);
                }
            }
        }
    }

    private void addCorrectRoadModifier(EntityLivingBase entity, String BlockUnderEntity) {
        if (BlockUnderEntity.equals(ROAD_BLOCK_IDS[0])) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(ROAD_MODIFIER_LIST.get(0));
        }
        if (BlockUnderEntity.equals(ROAD_BLOCK_IDS[1])) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(ROAD_MODIFIER_LIST.get(1));
        }
        if (BlockUnderEntity.equals(ROAD_BLOCK_IDS[2])) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(ROAD_MODIFIER_LIST.get(2));
        }
        if (BlockUnderEntity.equals(ROAD_BLOCK_IDS[3])) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(ROAD_MODIFIER_LIST.get(3));
        }
        if (BlockUnderEntity.equals(ROAD_BLOCK_IDS[4])) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(ROAD_MODIFIER_LIST.get(4));
        }
    }

    public static void addRoadBlocksFromConfig() {
        if (Config.BLOCK_ID_1 != "") {
            ROAD_BLOCKS.put("Block{" + Config.BLOCK_ID_1 + "}", ROAD_MODIFIER_LIST.get(0).func_111167_a());
            RoadHandler.ROAD_BLOCK_IDS[0] = "Block{" + Config.BLOCK_ID_1 + "}";
        }
        if (Config.BLOCK_ID_2 != "") {
            ROAD_BLOCKS.put("Block{" + Config.BLOCK_ID_2 + "}", ROAD_MODIFIER_LIST.get(1).func_111167_a());
            RoadHandler.ROAD_BLOCK_IDS[1] = "Block{" + Config.BLOCK_ID_2 + "}";
        }
        if (Config.BLOCK_ID_3 != "") {
            ROAD_BLOCKS.put("Block{" + Config.BLOCK_ID_3 + "}", ROAD_MODIFIER_LIST.get(2).func_111167_a());
            RoadHandler.ROAD_BLOCK_IDS[2] = "Block{" + Config.BLOCK_ID_3 + "}";
        }
        if (Config.BLOCK_ID_4 != "") {
            ROAD_BLOCKS.put("Block{" + Config.BLOCK_ID_4 + "}", ROAD_MODIFIER_LIST.get(3).func_111167_a());
            RoadHandler.ROAD_BLOCK_IDS[3] = "Block{" + Config.BLOCK_ID_4 + "}";
        }
        if (Config.BLOCK_ID_5 != "") {
            ROAD_BLOCKS.put("Block{" + Config.BLOCK_ID_5 + "}", ROAD_MODIFIER_LIST.get(4).func_111167_a());
            RoadHandler.ROAD_BLOCK_IDS[4] = "Block{" + Config.BLOCK_ID_5 + "}";
        }
    }
}

