/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.lib.util;

import com.codetaylor.mc.advancedmortars.modules.mortar.integration.crafttweaker.mtlib.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CraftTweakerUtil {
    public static void logError(String message) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String methodName = element.getMethodName();
            if (!"__script__".equals(methodName)) continue;
            CraftTweakerAPI.logError((String)(message + " (" + element.getFileName() + ":" + element.getLineNumber() + ")"));
            break;
        }
    }

    public static Ingredient toIngredient(IIngredient ingredient) {
        return new CTIngredientWrapper(ingredient);
    }

    public static Ingredient[][] toIngredientMatrix(IIngredient[][] ingredients) {
        Ingredient[][] result = new Ingredient[ingredients.length][];
        for (int row = 0; row < ingredients.length; ++row) {
            result[row] = new Ingredient[ingredients[row].length];
            for (int col = 0; col < ingredients[row].length; ++col) {
                result[row][col] = new CTIngredientWrapper(ingredients[row][col]);
            }
        }
        return result;
    }

    public static Ingredient[] toIngredientArray(IIngredient[] ingredients) {
        Ingredient[] result = new Ingredient[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            result[i] = new CTIngredientWrapper(ingredients[i]);
        }
        return result;
    }

    public static class CTIngredientWrapper
    extends Ingredient {
        private IIngredient ingredient;

        public CTIngredientWrapper(IIngredient ingredient) {
            super(new ItemStack[0]);
            this.ingredient = ingredient;
        }

        public int getAmount() {
            return this.ingredient.getAmount();
        }

        public ItemStack[] func_193365_a() {
            List stacks = this.ingredient != null ? this.ingredient.getItems() : Collections.emptyList();
            return InputHelper.toStacks(stacks.toArray(new IItemStack[stacks.size()]));
        }

        public boolean apply(@Nullable ItemStack itemStack) {
            if (this.ingredient == null) {
                return itemStack == null || itemStack.func_190926_b();
            }
            if (itemStack == null) {
                return false;
            }
            return this.ingredient.matches(InputHelper.toIItemStack(itemStack));
        }
    }
}

