/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="advancedmortars", name="advancedmortars.module.Mortar")
public class ModuleConfig {
    @Config.Comment(value={"Set to false to make the mortar drop its contents when moved."})
    public static boolean KEEP_CONTENTS = true;
    public static Client CLIENT = new Client();
    public static Recipes RECIPES = new Recipes();
    public static Durability DURABILITY = new Durability();

    @Mod.EventBusSubscriber(modid="advancedmortars")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("advancedmortars")) {
                ConfigManager.sync((String)"advancedmortars", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Durability {
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Set to 0 for infinite uses."})
        public int WOOD = 16;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Set to 0 for infinite uses."})
        public int STONE = 64;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Set to 0 for infinite uses."})
        public int IRON = 256;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Set to 0 for infinite uses."})
        public int DIAMOND = 1024;
    }

    public static class Recipes {
        @Config.Comment(value={"If set to true, the mortar will require an empty hand to use."})
        public boolean REQUIRE_EMPTY_HAND_TO_USE = false;
        @Config.RangeInt(min=0, max=20)
        @Config.Comment(value={"Minimum amount of hunger the player needs to operate a mortar.", "Set to 0 to disable."})
        public int MINIMUM_HUNGER_TO_USE = 0;
        @Config.RangeDouble(min=0.0, max=40.0)
        @Config.Comment(value={"Amount of exhaustion to charge the player per click required to complete a recipe.", "Set to 0 to disable."})
        public double EXHAUSTION_COST_PER_CLICK = 0.0;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Set to false to disable all default recipes."})
        public boolean ENABLE_DEFAULT_RECIPES = true;
    }

    public static class Client {
        @Config.Comment(value={"Set to false to hide the mortar interaction hints in the UI overlay."})
        public boolean DISPLAY_INTERACTION_HINTS = true;
        @Config.Comment(value={"Set to false to hide the mortar durability in the UI overlay."})
        public boolean DISPLAY_MORTAR_DURABILITY = true;
    }
}

