/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.event;

import com.codetaylor.mc.advancedmortars.lib.util.StackUtil;
import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleConfig;
import com.codetaylor.mc.advancedmortars.modules.mortar.block.BlockMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.render.HUDRender;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class MortarEventHandler {
    @SubscribeEvent
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState blockState = world.func_180495_p(pos);
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer.func_70093_af() && blockState.func_177230_c() instanceof BlockMortar) {
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityMortarBase) {
                boolean dropAllItems = !ModuleConfig.KEEP_CONTENTS;
                ItemStack itemStack = ((TileEntityMortarBase)tileEntity).destroy(dropAllItems, false, SoundEvents.field_187638_cR);
                StackUtil.spawnStackOnTop(world, itemStack, pos);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPreEvent(RenderGameOverlayEvent.Pre event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            TileEntity tileEntity;
            Minecraft minecraft = Minecraft.func_71410_x();
            RayTraceResult rayTraceResult = minecraft.field_71476_x;
            if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            BlockPos blockPos = rayTraceResult.func_178782_a();
            if (blockPos.func_177956_o() < 0 || blockPos.func_177956_o() >= 256) {
                return;
            }
            IBlockState blockState = minecraft.field_71441_e.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            if (block instanceof BlockMortar && (tileEntity = minecraft.field_71441_e.func_175625_s(blockPos)) instanceof TileEntityMortarBase && ModuleConfig.CLIENT.DISPLAY_MORTAR_DURABILITY) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPostEvent(RenderGameOverlayEvent.Post event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        HUDRender.render(event.getResolution());
    }
}

