/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.integration.jei;

import com.codetaylor.mc.advancedmortars.modules.mortar.integration.jei.JEIRecipeWrapperMortar;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class JEICategoryMortar
implements IRecipeCategory {
    private String uid;
    private String titleTranslateKey;
    private IDrawable background;

    public JEICategoryMortar(String uid, String titleTranslateKey, IDrawable background) {
        this.uid = uid;
        this.titleTranslateKey = titleTranslateKey;
        this.background = background;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.titleTranslateKey, (Object[])new Object[0]);
    }

    public String getModName() {
        return "advancedmortars";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        if (recipeWrapper instanceof JEIRecipeWrapperMortar) {
            IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
            List inputs = ingredients.getInputs(ItemStack.class);
            List outputList = ingredients.getOutputs(ItemStack.class);
            List outputs = (List)outputList.get(0);
            boolean secondaryOutputExists = outputList.size() > 1;
            int outputYPosition = 26;
            if (secondaryOutputExists) {
                outputYPosition = 16;
            }
            stacks.init(0, false, 110, outputYPosition);
            stacks.set(0, outputs);
            int count = inputs.size();
            float angle = (float)(Math.PI * 2 / (double)count);
            float radius = 26.0f;
            int offsetX = 25;
            int offsetY = 25;
            for (int index = 0; index < count; ++index) {
                int x = (int)(MathHelper.func_76134_b((float)(angle * (float)index)) * radius) + offsetX;
                int y = (int)(MathHelper.func_76126_a((float)(angle * (float)index)) * radius) + offsetY;
                stacks.init(index + 1, true, x, y);
            }
            for (int i = 1; i <= count; ++i) {
                stacks.set(i, (List)inputs.get(i - 1));
            }
            if (secondaryOutputExists) {
                stacks.init(count + 1, false, 110, outputYPosition + 23);
                stacks.set(count + 1, (List)outputList.get(1));
            }
        }
    }
}

