/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.tile;

import com.codetaylor.mc.advancedmortars.lib.util.StackUtil;
import com.codetaylor.mc.advancedmortars.modules.mortar.api.MortarAPI;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.IRecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.RecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.reference.EnumMortarType;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.IMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.util.Utils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class MortarDelegate
implements IMortar {
    private ItemStackHandler itemStackHandler;
    private EnumMortarType type;
    private Runnable changeObserver;
    private IRecipeMortar recipe;

    public MortarDelegate(EnumMortarType type, Runnable changeObserver) {
        this.type = type;
        this.changeObserver = changeObserver;
        this.itemStackHandler = new ItemStackHandler(8);
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Override
    public boolean canInsertItem(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        int count = itemStack.func_190916_E();
        ItemStack[] ingredients = new ItemStack[this.itemStackHandler.getSlots() + 1];
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ingredients[i] = this.itemStackHandler.getStackInSlot(i);
        }
        ingredients[this.itemStackHandler.getSlots()] = itemStack;
        if (!MortarAPI.RECIPE_REGISTRY.matchesPartial(this.type, ingredients)) {
            return false;
        }
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if ((itemStack = this.itemStackHandler.insertItem(i, itemStack, true)).func_190916_E() == count) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insertItem(ItemStack itemStack) {
        this.insertItemInternal(itemStack);
        this.updateRecipe();
    }

    private void insertItemInternal(ItemStack itemStack) {
        ItemStack resultStack = itemStack.func_77946_l();
        for (int i = 0; i < this.itemStackHandler.getSlots() && !(resultStack = this.itemStackHandler.insertItem(i, resultStack, false)).func_190926_b(); ++i) {
        }
        itemStack.func_190920_e(resultStack.func_190916_E());
        this.changeObserver.run();
    }

    @Override
    public ItemStack removeItem() {
        ItemStack itemStack = this.removeItemInternal();
        this.updateRecipe();
        return itemStack;
    }

    private ItemStack removeItemInternal() {
        int index = this.getLastNonEmptySlotIndex();
        if (index == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = this.itemStackHandler.getStackInSlot(index);
        this.itemStackHandler.setStackInSlot(index, ItemStack.field_190927_a);
        this.changeObserver.run();
        return toReturn;
    }

    @Override
    public void dropAllItems(World world, BlockPos pos) {
        while (!this.isEmpty()) {
            StackUtil.spawnStackOnTop(world, this.removeItemInternal(), pos);
        }
        this.updateRecipe();
    }

    @Override
    public int getOccupiedSlotCount() {
        int index = this.getFirstEmptySlotIndex();
        if (index == -1) {
            return this.itemStackHandler.getSlots();
        }
        return index;
    }

    @Override
    public boolean isEmpty() {
        return this.getOccupiedSlotCount() == 0;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return this.itemStackHandler.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        this.itemStackHandler.deserializeNBT(compound);
        this.updateRecipe();
    }

    @Override
    public IRecipeMortar getRecipe() {
        return this.recipe;
    }

    private void updateRecipe() {
        ItemStack stackInSlot;
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemStackHandler.getSlots() && !(stackInSlot = this.itemStackHandler.getStackInSlot(i)).func_190926_b(); ++i) {
            itemStackList.add(stackInSlot);
        }
        this.recipe = MortarAPI.RECIPE_REGISTRY.findRecipe(this.type, itemStackList.toArray(new ItemStack[itemStackList.size()]));
    }

    @Override
    public ItemStack[] doCrafting() {
        RecipeMortar recipe = (RecipeMortar)this.getRecipe();
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        ingredients.addAll(recipe.getIngredients());
        block0: for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            ItemStack[] matchingStacks = ingredient.func_193365_a();
            if (matchingStacks.length <= 0) continue;
            int requiredCount = matchingStacks[0].func_190916_E();
            for (int j = 0; j < this.itemStackHandler.getSlots(); ++j) {
                ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(j);
                if (stackInSlot.func_190926_b() || !Utils.ingredientApplyWithNBT(ingredient, stackInSlot)) continue;
                if (stackInSlot.func_190916_E() >= requiredCount) {
                    stackInSlot.func_190918_g(requiredCount);
                    continue block0;
                }
                requiredCount -= stackInSlot.func_190916_E();
                stackInSlot.func_190920_e(0);
            }
        }
        this.settleItemStacks();
        this.updateRecipe();
        this.changeObserver.run();
        return new ItemStack[]{recipe.getOutput(), recipe.getSecondaryOutput()};
    }

    private void settleItemStacks() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            stackList.add(stackInSlot);
            this.itemStackHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (ItemStack itemStack : stackList) {
            this.insertItemInternal(itemStack);
        }
    }

    private int getFirstEmptySlotIndex() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (!this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private int getLastNonEmptySlotIndex() {
        for (int i = this.itemStackHandler.getSlots() - 1; i >= 0; --i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }
}

