/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.MundaneRedstone.world;

import com.google.common.base.Predicate;
import com.svennieke.MundaneRedstone.config.MundaneConfigGen;
import com.svennieke.MundaneRedstone.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MundaneGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworld(world, random, chunkX, chunkZ);
            }
        }
    }

    private void generateOverworld(World world, Random rand, int x, int z) {
        if (MundaneConfigGen.generation.MundaneGenerate) {
            this.generateOre(ModBlocks.Mundane_Redstone_Ore, world, rand, x, z, MundaneConfigGen.mundanegen.MundaneMinVeinSize, MundaneConfigGen.mundanegen.MundaneMaxVeinSize, MundaneConfigGen.mundanegen.MundaneChance, 0, MundaneConfigGen.mundanegen.MundaneMaxHeight, Blocks.field_150348_b);
        }
    }

    public void generateOre(Block block, World world, Random random, int chunkX, int chunkZ, int minVeinSize, int maxVeinSize, int chance, int minY, int maxY, Block generateIn) {
        int veinSize = minVeinSize + random.nextInt(maxVeinSize - minVeinSize);
        int heightRange = maxY - minY;
        WorldGenMinable gen = new WorldGenMinable(block.func_176223_P(), veinSize, (Predicate)BlockMatcher.func_177642_a((Block)generateIn));
        for (int i = 0; i < chance; ++i) {
            int xRand = chunkX * 16 + random.nextInt(16);
            int yRand = random.nextInt(heightRange) + minY;
            int zRand = chunkZ * 16 + random.nextInt(16);
            gen.func_180709_b(world, random, new BlockPos(xRand, yRand, zRand));
        }
    }
}

