/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mpbasic.common.infopanel;

import com.gendeathrow.mpbasic.configs.InfoPanelConfigHandler;
import com.gendeathrow.mpbasic.core.MPBasic;
import com.gendeathrow.mputils.utils.JsonHandler;
import com.gendeathrow.mputils.utils.MPFileUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class InfoPanelPages {
    protected String panelId;
    protected int currentPage = 0;
    protected File file;
    boolean canChangePages = true;
    boolean isLoaded = false;
    protected ArrayList<PageProperties> pages = new ArrayList();
    protected boolean mustRead = false;

    public InfoPanelPages(String name, File fileIn) {
        this.file = fileIn;
        this.panelId = name;
        this.readJson();
    }

    public String getPanelID() {
        return this.panelId;
    }

    public boolean canSwitchPages() {
        return this.canChangePages;
    }

    public boolean forceRead() {
        return this.mustRead;
    }

    public int getPageCnt() {
        return this.pages.size();
    }

    @Nullable
    public File getCurrentPageFile() {
        if (!this.Valadate()) {
            return null;
        }
        return this.pages.get(this.currentPage).pageFile;
    }

    @Nullable
    public PageProperties getCurrentPageProperty() {
        if (!this.Valadate()) {
            return null;
        }
        return this.pages.get(this.currentPage);
    }

    public boolean Valadate() {
        return this.currentPage < this.pages.size();
    }

    public String readPage() {
        try {
            return this.pages.get(this.currentPage).readPage();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error reading file";
        }
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.currentPage;
        }
    }

    public boolean hasNextPage() {
        return this.currentPage + 1 < this.pages.size();
    }

    public void prevPage() {
        if (this.hasPrevPage()) {
            --this.currentPage;
        }
    }

    public boolean hasPrevPage() {
        return this.currentPage - 1 >= 0;
    }

    public void readJson() {
        this.pages.clear();
        JsonObject json = JsonHandler.ReadJsonFile((File)this.file);
        if (json.has(InfoPanelConfigHandler.NBTONLOGIN) && json.get(InfoPanelConfigHandler.NBTONLOGIN).getAsBoolean()) {
            InfoPanelConfigHandler.setOnLoginPage(this);
        }
        if (json.has(InfoPanelConfigHandler.NBTCANCHANGEPAGES)) {
            this.canChangePages = json.get(InfoPanelConfigHandler.NBTCANCHANGEPAGES).getAsBoolean();
        }
        if (json.has(InfoPanelConfigHandler.NBTMUSTREAD)) {
            this.mustRead = json.get(InfoPanelConfigHandler.NBTMUSTREAD).getAsBoolean();
        }
        JsonArray pageArray = json.get(InfoPanelConfigHandler.NBTPAGES).getAsJsonArray();
        for (JsonElement pagejson : pageArray) {
            PageProperties pageProperty = this.createPageProperty((JsonObject)pagejson);
            if (pageProperty == null) continue;
            this.pages.add(pageProperty);
        }
    }

    public PageProperties createPageProperty(JsonObject jsonIn) {
        File fileIn;
        int id = -1;
        String titleIn = "";
        boolean mustreadIn = false;
        int nextPageID = -1;
        if (jsonIn.has(InfoPanelConfigHandler.NBTTITLE)) {
            titleIn = jsonIn.get(InfoPanelConfigHandler.NBTTITLE).getAsString();
        }
        if (jsonIn.has(InfoPanelConfigHandler.NBTFILE)) {
            String textFile = jsonIn.get(InfoPanelConfigHandler.NBTFILE).getAsString();
            fileIn = new File(this.file.getParent(), textFile + ".txt");
            if (!fileIn.exists()) {
                MPBasic.logger.error("Failed to create Page : File '" + new File(this.file.getParent(), textFile).getPath() + "' for page " + id + " in " + this.file);
                return null;
            }
        } else {
            MPBasic.logger.error("Failed to create Page : Missing file name for page " + id + " in " + this.file);
            return null;
        }
        if (jsonIn.has(InfoPanelConfigHandler.NBTMUSTREAD)) {
            mustreadIn = jsonIn.get(InfoPanelConfigHandler.NBTMUSTREAD).getAsBoolean();
        }
        return new PageProperties(id, titleIn, fileIn, mustreadIn, nextPageID);
    }

    public class CustomPageButton {
    }

    public static class PageProperties {
        private int pageID;
        private String title;
        private File pageFile;
        private boolean mustRead = false;
        private int nextPage = 0;

        public PageProperties(int idIn, String titleIn, File fileIn, boolean mustReadIn, int nextPageID) {
            this.pageID = idIn;
            this.title = titleIn;
            this.pageFile = fileIn;
            this.mustRead = mustReadIn;
            this.nextPage = nextPageID;
        }

        public int getPageID() {
            return this.pageID;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean mustPlayerRead() {
            return this.mustRead;
        }

        public String readPage() throws IOException {
            return MPFileUtils.readFile((File)this.pageFile);
        }
    }
}

