/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mpbasic.configs;

import com.gendeathrow.mpbasic.configs.MPBConfigHandler;
import com.gendeathrow.mpbasic.core.MPBasic;
import com.gendeathrow.mputils.utils.MPFileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class NotificationsConfigs {
    public static File notification = new File(MPBConfigHandler.MPBConfigDir, "onscreen_notifications.json");
    public static HashMap<String, NotificationObject> LoadedNotifications = new HashMap();

    public static void load() {
        if (!notification.exists()) {
            NotificationsConfigs.CreateDirectory();
        }
        try {
            NotificationsConfigs.readJson();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reloadConfig() {
        LoadedNotifications.clear();
        try {
            NotificationsConfigs.readJson();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void readJson() throws IOException {
        String fileRead = MPFileUtils.readFile((File)notification);
        JsonObject json = (JsonObject)new Gson().fromJson(fileRead, JsonObject.class);
        if (json.has("onScreenNotifications")) {
            JsonArray notifications = json.get("onScreenNotifications").getAsJsonArray();
            for (int i = 0; i < notifications.size(); ++i) {
                JsonObject single = notifications.get(i).getAsJsonObject();
                String id = null;
                String soundFile = null;
                ArrayList<String> lines = new ArrayList<String>();
                String itemID = ItemStack.field_190927_a.func_77973_b().getRegistryName().toString();
                int bgColor = Color.GRAY.getRGB();
                int borderColor = Color.BLACK.getRGB();
                if (single.has("id")) {
                    id = single.get("id").getAsString();
                }
                if (single.has("soundlocation")) {
                    soundFile = single.get("soundlocation").getAsString();
                }
                if (single.has("itemstack")) {
                    itemID = single.get("itemstack").getAsString();
                }
                if (single.has("bgColor")) {
                    try {
                        bgColor = Color.decode(single.get("bgColor").getAsString()).getRGB();
                    }
                    catch (NumberFormatException e) {
                        MPBasic.logger.error("Error converting Hex number bgColor : '" + single.get("bgColor").getAsString() + "'");
                        e.printStackTrace();
                    }
                }
                if (single.has("borderColor")) {
                    try {
                        borderColor = Color.decode(single.get("borderColor").getAsString()).getRGB();
                    }
                    catch (NumberFormatException e) {
                        MPBasic.logger.error("Error converting Hex number borderColor : '" + single.get("bgColor").getAsString() + "'");
                        e.printStackTrace();
                    }
                }
                if (single.has("lines")) {
                    JsonArray jsonlist = single.get("lines").getAsJsonArray();
                    Iterator itr = jsonlist.iterator();
                    while (itr.hasNext()) {
                        String nx = ((JsonElement)itr.next()).getAsString();
                        lines.add(nx);
                    }
                }
                if (id == null || lines.isEmpty()) continue;
                LoadedNotifications.put(id, new NotificationObject(id, itemID, soundFile, lines, bgColor, borderColor));
            }
        }
    }

    protected static void CreateDirectory() {
        if (!MPBConfigHandler.MPBConfigDir.exists()) {
            MPBConfigHandler.MPBConfigDir.mkdirs();
        }
        NotificationsConfigs.generateExamples();
    }

    private static void generateExamples() {
        if (notification.getParentFile() != null) {
            notification.getParentFile().mkdirs();
        }
        JsonObject json = new JsonObject();
        JsonArray notificationList = new JsonArray();
        JsonObject darkostoObject = new JsonObject();
        darkostoObject.addProperty("id", "darkosto");
        darkostoObject.addProperty("soundlocation", SoundEvents.field_187802_ec.getRegistryName().toString());
        darkostoObject.addProperty("bgColor", "#" + Integer.toHexString(Color.GRAY.getRGB()).substring(2));
        darkostoObject.addProperty("borderColor", "#" + Integer.toHexString(Color.BLACK.getRGB()).substring(2));
        JsonArray darkLines = new JsonArray();
        darkLines.add(TextFormatting.BLUE + "" + TextFormatting.UNDERLINE + "Happy Birthday!!!");
        darkLines.add(TextFormatting.DARK_GREEN + "Happy Birthday to you!");
        darkLines.add(TextFormatting.DARK_GREEN + "Happy Birthday to you!");
        darkLines.add(TextFormatting.DARK_PURPLE + "Happy Birthday Darkosto!");
        darkLines.add(TextFormatting.DARK_GREEN + "Happy Birthday to you!");
        darkostoObject.add("lines", (JsonElement)darkLines);
        notificationList.add((JsonElement)darkostoObject);
        JsonObject exampleObject = new JsonObject();
        exampleObject.addProperty("id", "example");
        exampleObject.addProperty("soundlocation", SoundEvents.field_187572_ar.getRegistryName().toString());
        JsonArray exampleLines = new JsonArray();
        exampleLines.add(TextFormatting.RED + "" + TextFormatting.UNDERLINE + "Boom!!!");
        exampleLines.add(TextFormatting.YELLOW + "Did I scare you?");
        exampleObject.add("lines", (JsonElement)exampleLines);
        notificationList.add((JsonElement)exampleObject);
        json.add("onScreenNotifications", (JsonElement)notificationList);
        ArrayList<String> jsonLines = new ArrayList<String>();
        jsonLines.add(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json));
        try {
            MPFileUtils.createSaveTextFile((File)notification, jsonLines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class NotificationObject {
        public String id;
        public String itemstackID;
        public String soundLocation;
        public List<String> lines;
        public int bgColor;
        public int borderColor;

        public NotificationObject(String idIn, String itemIn, String soundLocationIn, List<String> linesIn, int bgColorIn, int borderColorIn) {
            this.id = idIn;
            this.itemstackID = itemIn;
            this.soundLocation = soundLocationIn;
            this.lines = linesIn;
            this.bgColor = bgColorIn;
            this.borderColor = borderColorIn;
        }
    }
}

