/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.common.compression.BackupHelper;
import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.info.CreatingBackupInfo;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.mc.AromaBackup;
import aroma1997.backup.mc.Config;
import aroma1997.backup.mc.EventListener;
import aroma1997.backup.mc.api.BackupEvent;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.LocalizationHelper;
import aroma1997.core.util.Util;
import aroma1997.core.util.registry.TickRegistry;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Logger;

public final class ThreadBackup
implements Runnable {
    private static volatile ThreadBackup instance;
    private final CreatingBackupInfo info;

    private ThreadBackup(BackupType type) throws FileAlreadyExistsException {
        File parentBackup;
        List<ExistingBackupInfo> info = null;
        if (type == BackupType.DEFAULT) {
            try {
                ExistingBackupInfo backup;
                info = BackupInfoUtil.listBackupsForWorld(new File(Config.instance.location), Util.getWorldName());
                type = info.isEmpty() ? BackupType.FULL : ((backup = Collections.max(info)).getAmountParents() < Config.instance.toCreateincremental ? BackupType.INCREMENTAL : BackupType.FULL);
            }
            catch (IOException e) {
                LogHelper.logException((String)"Failed to load backup information. Creating a full backup.", (Throwable)e);
                type = BackupType.FULL;
            }
        }
        assert (type != BackupType.DEFAULT);
        if (type == BackupType.FULL) {
            parentBackup = null;
        } else {
            try {
                if (info == null) {
                    info = BackupInfoUtil.listBackupsForWorld(new File(Config.instance.location), Util.getWorldName());
                }
                if (info.isEmpty()) {
                    AromaBackup.instance.logger.warn("Could not find a previous backup for a forced incremental backup.");
                    AromaBackup.instance.logger.warn("Doung a full one instead.");
                    parentBackup = null;
                } else {
                    parentBackup = Collections.max(info).getBackupFile();
                }
            }
            catch (IOException e) {
                LogHelper.logException((String)"Failed to load backup information. Creating a full backup.", (Throwable)e);
                parentBackup = null;
            }
        }
        Date date = new Date();
        this.info = new CreatingBackupInfo(Config.instance.getBackupFile(Util.getWorldName(), date), parentBackup, Util.getWorldName(), date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)LocalizationHelper.localize((String)("aromabackup:backup.start." + AromaBackup.getSideString())));
            if (this.makeBackup()) {
                LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)LocalizationHelper.localize((String)("aromabackup:backup.done." + AromaBackup.getSideString())));
            } else {
                LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)LocalizationHelper.localize((String)("aromabackup:backup.failed." + AromaBackup.getSideString())));
            }
        }
        finally {
            Class<ThreadBackup> clazz = ThreadBackup.class;
            synchronized (ThreadBackup.class) {
                instance = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeBackup() {
        AromaBackup.instance.logger.trace("Starting new backup. Target: " + this.info.getBackupFile() + " Incremental: " + this.info.isIncremental());
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Triple t = (Triple)ThreadBackup.executeOnServerThreadAndWait(() -> {
            WorldServer[] worlds = server.field_71305_c;
            boolean[] state = new boolean[worlds.length];
            this.saveLevel(true, state, worlds);
            try {
                MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.BackupStartEvent());
            }
            catch (Exception e) {
                AromaBackup.instance.logger.error("Failed to post Backup Event. Continuing...");
                e.printStackTrace();
            }
            return new ImmutableTriple((Object)worlds, (Object)state, this.getFileLocations(server));
        });
        WorldServer[] worlds = (WorldServer[])t.getLeft();
        boolean[] state = (boolean[])t.getMiddle();
        Map files = (Map)t.getRight();
        try {
            BackupHelper.makeBackup(this.info, files);
            List<ExistingBackupInfo> info = BackupInfoUtil.listBackupsForWorld(new File(Config.instance.location), Util.getWorldName());
            PriorityQueue<ExistingBackupInfo> toCheck = new PriorityQueue<ExistingBackupInfo>(info.size());
            for (ExistingBackupInfo current : info) {
                if (current.isIncremental() != this.info.isIncremental()) continue;
                toCheck.add(current);
            }
            int max = this.info.isIncremental() ? Config.instance.toKeepIncremental : Config.instance.toKeepFull;
            AromaBackup.instance.logger.trace("Backups found / backups to keep: " + toCheck.size() + "/" + max);
            if (toCheck.size() > max) {
                AromaBackup.instance.logger.trace("Found more backups, than we should keep.");
                while (toCheck.size() > max) {
                    ExistingBackupInfo tmp = (ExistingBackupInfo)toCheck.poll();
                    tmp.delete(new File(Config.instance.location));
                    AromaBackup.instance.logger.info("Deleted backup " + tmp.getBackupFile().getName() + ".");
                }
            }
            try {
                MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.BackupDoneEvent(this.info.getBackupFile()));
            }
            catch (Exception e) {
                AromaBackup.instance.logger.error("Failed to post Backup Event. Continuing...");
                e.printStackTrace();
            }
            EventListener.playerOnline = server.func_184103_al().func_181057_v().size() > 0;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            AromaBackup.instance.logger.error("Failed to do server backup.");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadBackup.executeOnServerThreadAndWait(() -> this.saveLevel(false, state, worlds));
        }
    }

    private void saveLevel(boolean value, boolean[] state, WorldServer[] worlds) {
        assert (worlds.length == state.length);
        for (int i = 0; i < worlds.length; ++i) {
            WorldServer world = worlds[i];
            if (world == null) continue;
            if (value) {
                state[i] = world.field_73058_d;
                try {
                    world.field_73058_d = false;
                    world.func_73044_a(true, null);
                }
                catch (Exception e) {
                    AromaBackup.instance.logger.error("Failed saving the world " + world.field_73011_w.getDimension());
                    LogHelper.logException((String)"Failed to save the world.", (Throwable)e);
                }
                world.func_104140_m();
                continue;
            }
            world.field_73058_d = state[i];
        }
    }

    private Map<File, String> getFileLocations(MinecraftServer server) {
        File worldDir = Util.getWorldFolder();
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(worldDir.list()));
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            if (Config.instance.shouldSaveDimension(i2)) continue;
            WorldProvider provider = DimensionManager.createProviderFor((int)i2);
            files.remove("DIM" + provider.getDimension());
            files.remove(provider.getSaveFolder());
        }
        HashMap<File, String> map = new HashMap<File, String>();
        for (String folder : files) {
            map.put(new File(worldDir, folder), "");
        }
        return map;
    }

    public static synchronized boolean startBackup(BackupType type) {
        if (instance != null) {
            return false;
        }
        try {
            instance = new ThreadBackup(type);
        }
        catch (FileAlreadyExistsException e) {
            instance = null;
            return false;
        }
        Thread thread = new Thread(instance);
        thread.setName("Aromabackup-Backup");
        thread.start();
        return true;
    }

    public static synchronized boolean isBackupRunning() {
        return instance != null;
    }

    public static synchronized boolean startBackupOnSchedule() {
        if (!EventListener.playerOnline && Config.instance.skipBackup) {
            AromaBackup.instance.logger.trace("Skipping backup, because no players were online, since the last one.");
            return false;
        }
        return ThreadBackup.startBackup(BackupType.DEFAULT);
    }

    static void executeOnServerThreadAndWait(Runnable runnable) {
        FutureTask<Object> task = new FutureTask<Object>(runnable, null);
        TickRegistry.SERVER.addSingleCallback(task);
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    static <T> T executeOnServerThreadAndWait(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        TickRegistry.SERVER.addSingleCallback(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static enum BackupType {
        DEFAULT,
        FULL,
        INCREMENTAL;

    }
}

